<?php
// This page displays a shared event for public access

// Get event data
$event = $sharedEvent;
$organizer = getEntityById(ORGANIZERS_FILE, $event['organizer_id']);
$promotions = getEventPromotions($event['id']);
$pins = getEventPins($event['id']);

// Format dates for display
$formatDate = function($date) {
    return date('d F Y', strtotime($date));
};
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="robots" content="noindex, nofollow">
    <link rel="icon" type="image/png" href="https://app.dezki.biz.id/linkpic/assets/uploads/680379d79bff3.png" />
    <title><?= htmlspecialchars($event['name']) ?> - Event-Sinergi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <style>
        :root {
            --primary: #e60000;
            --secondary: #000000;
            --light: #ffffff;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f8f9fa;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }
        
        .navbar {
            background-color: var(--primary);
        }
        
        .navbar-brand {
            color: var(--light) !important;
            font-weight: bold;
        }
        
        .btn-primary {
            background-color: var(--primary);
            border-color: var(--primary);
        }
        
        .btn-primary:hover {
            background-color: #b80000;
            border-color: #b80000;
        }
        
        .card {
            border-radius: 8px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            margin-bottom: 20px;
        }
        
        .card-header {
            background-color: var(--primary);
            color: var(--light);
            font-weight: bold;
        }
        
        .event-header {
            background-color: var(--primary);
            color: var(--light);
            padding: 2rem 0;
            margin-bottom: 2rem;
        }
        
        .event-poster {
            max-width: 100%;
            height: auto;
            border-radius: 8px;
            margin-bottom: 1rem;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
        }
        
        .timeline {
            position: relative;
            padding-left: 2rem;
            margin-bottom: 2rem;
        }
        
        .timeline::before {
            content: '';
            position: absolute;
            left: 0;
            top: 0;
            height: 100%;
            width: 2px;
            background-color: var(--primary);
        }
        
        .timeline-item {
            position: relative;
            padding-bottom: 1.5rem;
        }
        
        .timeline-item::before {
            content: '';
            position: absolute;
            left: -2rem;
            top: 0;
            width: 1rem;
            height: 1rem;
            border-radius: 50%;
            background-color: var(--primary);
        }
        
        .main-content {
            flex: 1;
        }
        
        footer {
            margin-top: auto;
            background-color: var(--secondary);
            color: var(--light);
            text-align: center;
            padding: 1rem 0;
            width: 100%;
        }

        .promotion-card {
            border-left: 5px solid var(--primary);
            margin-bottom: 1rem;
        }
        
        .completed {
            background-color: #e8f5e9;
            border-left: 5px solid #4caf50;
        }
        
        .overdue {
            background-color: #ffebee;
            border-left: 5px solid #f44336;
        }
        
        .upcoming {
            background-color: #e3f2fd;
            border-left: 5px solid #2196f3;
        }
        
        .today {
            background-color: #fff8e1;
            border-left: 5px solid #ffc107;
        }
        
        /* Responsive adjustments */
        @media (max-width: 768px) {
            .container {
                padding: 10px;
            }
            
            .event-header {
                padding: 1rem 0;
            }
            
            .event-poster {
                margin-bottom: 1rem;
            }
        }
    </style>
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-dark">
        <div class="container">
            <a class="navbar-brand" href="#">Event-Sinergi</a>
        </div>
    </nav>
    
    <!-- Event Header -->
    <div class="event-header">
        <div class="container">
            <h1 class="display-4"><?= htmlspecialchars($event['name']) ?></h1>
            <p class="lead">Diselenggarakan oleh: <?= htmlspecialchars($organizer['name']) ?></p>
        </div>
    </div>
    
    <div class="container main-content">
        <div class="row">
            <!-- Event Details -->
            <div class="col-lg-8">
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0">Detail Event</h5>
                    </div>
                    <div class="card-body">
                        <div id="carouselEventImages" class="carousel slide mb-4" data-bs-ride="carousel">
                            <div class="carousel-inner">
                                <?php if (!empty($event['images'])): ?>
                                    <?php foreach ($event['images'] as $index => $image): ?>
                                        <div class="carousel-item <?= $index === 0 ? 'active' : '' ?>">
                                            <img src="<?= htmlspecialchars($image) ?>" class="d-block w-100 event-poster" alt="Poster Event">
                                        </div>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <div class="carousel-item active">
                                        <div class="d-block w-100 bg-light text-center p-5">
                                            <p class="text-muted">Tidak ada gambar tersedia</p>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <?php if (count($event['images']) > 1): ?>
                                <button class="carousel-control-prev" type="button" data-bs-target="#carouselEventImages" data-bs-slide="prev">
                                    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                                    <span class="visually-hidden">Previous</span>
                                </button>
                                <button class="carousel-control-next" type="button" data-bs-target="#carouselEventImages" data-bs-slide="next">
                                    <span class="carousel-control-next-icon" aria-hidden="true"></span>
                                    <span class="visually-hidden">Next</span>
                                </button>
                            <?php endif; ?>
                        </div>
                        
                        <div class="mb-4">
                            <h5>Deskripsi Event</h5>
                            <div class="p-3 bg-light rounded">
                                <?= nl2br(htmlspecialchars($event['description'])) ?>
                            </div>
                            <button class="btn btn-sm btn-outline-primary mt-2 copy-btn" data-copy="<?= htmlspecialchars($event['description']) ?>">
                                <i class="bi bi-clipboard"></i> Salin Deskripsi
                            </button>
                        </div>
                        
                        <div class="mb-4">
                            <h5>Timeline Event</h5>
                            <div class="timeline">
                                <div class="timeline-item">
                                    <h6>Pendaftaran Dibuka</h6>
                                    <p><?= $formatDate($event['registration_start']) ?></p>
                                </div>
                                <div class="timeline-item">
                                    <h6>Pendaftaran Ditutup</h6>
                                    <p><?= $formatDate($event['registration_end']) ?></p>
                                </div>
                                <div class="timeline-item">
                                    <h6>Pelaksanaan Event</h6>
                                    <p><?= $formatDate($event['event_start']) ?> - <?= $formatDate($event['event_end']) ?></p>
                                </div>
                                <div class="timeline-item">
                                    <h6>Akses Penghargaan</h6>
                                    <p><?= $formatDate($event['award_access']) ?></p>
                                </div>
                                <div class="timeline-item">
                                    <h6>Sapu Bersih</h6>
                                    <p><?= $formatDate($event['cleanup_date']) ?></p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="d-grid gap-2">
                            <a href="https://wa.me/<?= htmlspecialchars(ltrim($organizer['contact'], '+')) ?>" target="_blank" class="btn btn-success">
                                <i class="bi bi-whatsapp"></i> Hubungi Penyelenggara
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Sidebar -->
            <div class="col-lg-4">
                <!-- Download Images -->
                <?php if (!empty($event['images'])): ?>
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="mb-0">Unduh Poster</h5>
                        </div>
                        <div class="card-body">
                            <?php foreach ($event['images'] as $index => $image): ?>
                                <div class="d-grid mb-2">
                                    <a href="<?= htmlspecialchars($image) ?>" target="_blank" download class="btn btn-outline-primary">
                                        <i class="bi bi-download"></i> Unduh Poster <?= $index + 1 ?>
                                    </a>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                <?php endif; ?>
                
                <!-- Media Partner Schedule -->
                <?php if (!empty($promotions)): ?>
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="mb-0">Jadwal Media Partner</h5>
                        </div>
                        <div class="card-body">
                            <?php foreach ($promotions as $promotion): ?>
                                <?php 
                                $mediaPartner = getEntityById(MEDIA_PARTNERS_FILE, $promotion['media_partner_id']);
                                
                                $postDate = strtotime($promotion['post_date']);
                                $now = time();
                                $dayDiff = floor(($postDate - $now) / (60 * 60 * 24));
                                
                                $cardClass = 'promotion-card';
                                $statusText = '';
                                
                                if ($promotion['completed']) {
                                    $cardClass = 'completed';
                                    $statusText = '<span class="badge bg-success">Sudah Diposting</span>';
                                } elseif ($dayDiff < 0) {
                                    $cardClass = 'overdue';
                                    $statusText = '<span class="badge bg-danger">Terlambat</span>';
                                } elseif ($dayDiff === 0) {
                                    $cardClass = 'today';
                                    $statusText = '<span class="badge bg-warning">Hari Ini</span>';
                                } else {
                                    $cardClass = 'upcoming';
                                    $statusText = '<span class="badge bg-primary">Dalam ' . $dayDiff . ' hari</span>';
                                }
                                ?>
                                <div class="card <?= $cardClass ?>">
                                    <div class="card-body">
                                        <div class="d-flex justify-content-between align-items-start">
                                            <div>
                                                <h6><?= htmlspecialchars($mediaPartner['name']) ?></h6>
                                                <p class="mb-1">
                                                    <strong>Tanggal:</strong> <?= date('d/m/Y', $postDate) ?>
                                                </p>
                                            </div>
                                            <div>
                                                <?= $statusText ?>
                                            </div>
                                        </div>
                                        <div class="mt-2">
                                            <a href="https://instagram.com/<?= htmlspecialchars(ltrim($mediaPartner['instagram'], '@')) ?>" target="_blank" class="btn btn-sm btn-outline-dark">
                                                <i class="bi bi-instagram"></i> Instagram
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                <?php endif; ?>
                
                <!-- Pin Schedule -->
                <?php if (!empty($pins)): ?>
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="mb-0">Jadwal Pin</h5>
                        </div>
                        <div class="card-body">
                            <?php foreach ($pins as $pin): ?>
                                <?php 
                                $mediaPartner = getEntityById(MEDIA_PARTNERS_FILE, $pin['media_partner_id']);
                                
                                $startDate = strtotime($pin['start_date']);
                                $endDate = strtotime($pin['end_date']);
                                $now = time();
                                
                                $cardClass = 'promotion-card';
                                $statusText = '';
                                
                                if ($pin['completed']) {
                                    $cardClass = 'completed';
                                    $statusText = '<span class="badge bg-success">Selesai</span>';
                                } elseif ($now < $startDate) {
                                    $cardClass = 'upcoming';
                                    $statusText = '<span class="badge bg-primary">Akan Datang</span>';
                                } elseif ($now > $endDate) {
                                    $cardClass = 'overdue';
                                    $statusText = '<span class="badge bg-danger">Sudah Berakhir</span>';
                                } else {
                                    $cardClass = 'today';
                                    $statusText = '<span class="badge bg-warning">Aktif</span>';
                                }
                                ?>
                                <div class="card <?= $cardClass ?>">
                                    <div class="card-body">
                                        <div class="d-flex justify-content-between align-items-start">
                                            <div>
                                                <h6><?= htmlspecialchars($mediaPartner['name']) ?></h6>
                                                <p class="mb-1">
                                                    <strong>Periode:</strong> <?= date('d/m/Y', $startDate) ?> - <?= date('d/m/Y', $endDate) ?>
                                                </p>
                                            </div>
                                            <div>
                                                <?= $statusText ?>
                                            </div>
                                        </div>
                                        <div class="mt-2">
                                            <a href="https://instagram.com/<?= htmlspecialchars(ltrim($mediaPartner['instagram'], '@')) ?>" target="_blank" class="btn btn-sm btn-outline-dark">
                                                <i class="bi bi-instagram"></i> Instagram
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <!-- Footer -->
    <footer>
        <p class="mb-0">Event-Sinergi &copy; <?= date('Y') ?> - Sistem Pengelolaan Event Media Partner</p>
    </footer>
    
    <!-- JavaScript -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Copy to clipboard functionality
            const copyButtons = document.querySelectorAll('.copy-btn');
            
            if (copyButtons) {
                copyButtons.forEach(button => {
                    button.addEventListener('click', function() {
                        const textToCopy = this.getAttribute('data-copy');
                        const textArea = document.createElement('textarea');
                        textArea.value = textToCopy;
                        document.body.appendChild(textArea);
                        textArea.select();
                        document.execCommand('copy');
                        document.body.removeChild(textArea);
                        
                        // Change button text temporarily
                        const originalText = this.innerHTML;
                        this.innerHTML = '<i class="bi bi-check"></i> Disalin!';
                        setTimeout(() => {
                            this.innerHTML = originalText;
                        }, 2000);
                    });
                });
            }
        });
    </script>
</body>
</html>