<div class="row mb-4">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Daftar Pin Event</h5>
            </div>
            <div class="card-body">
                <?php
                $pins = getCurrentPins();
                
                if (empty($pins)) {
                    echo '<div class="alert alert-info">Belum ada pin event.</div>';
                } else {
                    foreach ($pins as $pin) {
                        $event = getEntityById(EVENTS_FILE, $pin['event_id']);
                        $mediaPartner = getEntityById(MEDIA_PARTNERS_FILE, $pin['media_partner_id']);
                        
                        $startDate = strtotime($pin['start_date']);
                        $endDate = strtotime($pin['end_date']);
                        $now = time();
                        
                        $cardClass = 'promotion-card';
                        $statusText = '';
                        
                        if ($pin['completed']) {
                            $cardClass = 'completed';
                            $statusText = '<span class="badge bg-success">Selesai</span>';
                        } elseif ($now < $startDate) {
                            $cardClass = 'upcoming';
                            $statusText = '<span class="badge bg-primary">Akan Datang</span>';
                        } elseif ($now > $endDate) {
                            $cardClass = 'overdue';
                            $statusText = '<span class="badge bg-danger">Sudah Berakhir</span>';
                        } else {
                            $cardClass = 'today';
                            $statusText = '<span class="badge bg-warning">Aktif</span>';
                        }
                        ?>
                        <div class="card mb-3 <?= $cardClass ?>">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-8">
                                        <h5><?= htmlspecialchars($event['name']) ?> <?= $statusText ?></h5>
                                        <p class="mb-1"><strong>Periode:</strong> <?= date('d/m/Y', $startDate) ?> - <?= date('d/m/Y', $endDate) ?></p>
                                        <p class="mb-1"><strong>Media Partner:</strong> <?= htmlspecialchars($mediaPartner['name']) ?></p>
                                    </div>
                                    <div class="col-md-4 text-md-end mt-3 mt-md-0">
                                        <a href="https://instagram.com/<?= htmlspecialchars(ltrim($mediaPartner['instagram'], '@')) ?>" target="_blank" class="btn btn-sm btn-outline-secondary mb-2">
                                            <i class="bi bi-instagram"></i> Lihat Instagram
                                        </a>
                                        <?php if (!$pin['completed']): ?>
                                            <form method="post" class="d-inline">
                                                <input type="hidden" name="action" value="mark_pin_completed">
                                                <input type="hidden" name="pin_id" value="<?= $pin['id'] ?>">
                                                <button type="submit" class="btn btn-sm btn-primary">
                                                    <i class="bi bi-check-circle"></i> Tandai Selesai
                                                </button>
                                            </form>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php
                    }
                }
                ?>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Tambah Pin Event</h5>
            </div>
            <div class="card-body">
                <form method="post">
                    <input type="hidden" name="action" value="add_pin">
                    <div class="mb-3">
                        <label for="pin_event_id" class="form-label">Event</label>
                        <select class="form-select" id="pin_event_id" name="event_id" required>
                            <option value="">Pilih Event</option>
                            <?php
                            $events = loadData(EVENTS_FILE);
                            foreach ($events as $event) {
                                echo '<option value="' . $event['id'] . '">' . htmlspecialchars($event['name']) . '</option>';
                            }
                            ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="pin_media_partner_id" class="form-label">Media Partner</label>
                        <select class="form-select" id="pin_media_partner_id" name="media_partner_id" required>
                            <option value="">Pilih Media Partner</option>
                            <?php
                            $mediaPartners = loadData(MEDIA_PARTNERS_FILE);
                            foreach ($mediaPartners as $partner) {
                                echo '<option value="' . $partner['id'] . '">' . htmlspecialchars($partner['name']) . '</option>';
                            }
                            ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="start_date" class="form-label">Tanggal Mulai</label>
                        <input type="date" class="form-control" id="start_date" name="start_date" required>
                    </div>
                    <div class="mb-3">
                        <label for="end_date" class="form-label">Tanggal Berakhir</label>
                        <input type="date" class="form-control" id="end_date" name="end_date" required>
                    </div>
                    <button type="submit" class="btn btn-primary">Simpan</button>
                </form>
            </div>
        </div>
    </div>
</div>