<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Daftar Media Partner</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Nama</th>
                                <th>Instagram</th>
                                <th>WhatsApp</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $mediaPartners = loadData(MEDIA_PARTNERS_FILE);
                            if (empty($mediaPartners)) {
                                echo '<tr><td colspan="4" class="text-center">Belum ada media partner.</td></tr>';
                            } else {
                                foreach ($mediaPartners as $partner) {
                                    ?>
                                    <tr>
                                        <td><?= htmlspecialchars($partner['name']) ?></td>
                                        <td><a href="https://instagram.com/<?= htmlspecialchars(ltrim($partner['instagram'], '@')) ?>" target="_blank"><?= htmlspecialchars($partner['instagram']) ?></a></td>
                                        <td><a href="https://wa.me/<?= htmlspecialchars(ltrim($partner['whatsapp'], '+')) ?>" target="_blank"><?= htmlspecialchars($partner['whatsapp']) ?></a></td>
                                        <td>
                                            <a href="index.php?page=add_promotion&media_partner_id=<?= $partner['id'] ?>" class="btn btn-sm btn-outline-primary">Jadwalkan</a>
                                        </td>
                                    </tr>
                                    <?php
                                }
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Tambah Media Partner</h5>
            </div>
            <div class="card-body">
                <form method="post">
                    <input type="hidden" name="action" value="add_media_partner">
                    <div class="mb-3">
                        <label for="name" class="form-label">Nama</label>
                        <input type="text" class="form-control" id="name" name="name" required>
                    </div>
                    <div class="mb-3">
                        <label for="instagram" class="form-label">Instagram</label>
                        <input type="text" class="form-control" id="instagram" name="instagram" placeholder="@username" required>
                    </div>
                    <div class="mb-3">
                        <label for="whatsapp" class="form-label">WhatsApp</label>
                        <input type="text" class="form-control" id="whatsapp" name="whatsapp" placeholder="628xxxxxxxxxx" required>
                    </div>
                    <button type="submit" class="btn btn-primary">Simpan</button>
                </form>
            </div>
        </div>
    </div>
</div>