<div class="card">
    <div class="card-header">
        <h5 class="mb-0">Daftar Event</h5>
    </div>
    <div class="card-body">
        <?php
        $events = loadData(EVENTS_FILE);
        $organizers = loadData(ORGANIZERS_FILE);
        
        if (empty($events)) {
            echo '<div class="alert alert-info">Belum ada event. Silakan buat rencana event terlebih dahulu, lalu konversi menjadi event.</div>';
            echo '<a href="index.php?page=event_plans" class="btn btn-primary">Buat Rencana Event</a>';
        } else {
            ?>
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Nama Event</th>
                            <th>Penyelenggara</th>
                            <th>Tanggal Pelaksanaan</th>
                            <th>Link Berbagi</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($events as $event): ?>
                            <?php
                            $organizerName = '';
                            foreach ($organizers as $organizer) {
                                if ($organizer['id'] === $event['organizer_id']) {
                                    $organizerName = $organizer['name'];
                                    break;
                                }
                            }
                            
                            $shareableUrl = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http";
                            $shareableUrl .= "://" . $_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF'] . "?share=" . $event['shareable_link'];
                            ?>
                            <tr>
                                <td><?= htmlspecialchars($event['name']) ?></td>
                                <td><?= htmlspecialchars($organizerName) ?></td>
                                <td>
                                    <?= date('d/m/Y', strtotime($event['event_start'])) ?> - 
                                    <?= date('d/m/Y', strtotime($event['event_end'])) ?>
                                </td>
                                <td>
                                    <div class="input-group input-group-sm">
                                        <input type="text" class="form-control form-control-sm share-link-input" value="<?= $shareableUrl ?>" readonly>
                                        <button class="btn btn-outline-secondary copy-btn" type="button" data-copy="<?= $shareableUrl ?>">
                                            <i class="bi bi-clipboard"></i>
                                        </button>
                                    </div>
                                    <form method="post" class="mt-1">
                                        <input type="hidden" name="action" value="regenerate_link">
                                        <input type="hidden" name="event_id" value="<?= $event['id'] ?>">
                                        <button type="submit" class="btn btn-sm btn-outline-danger">
                                            <i class="bi bi-arrow-repeat"></i> Buat Ulang Link
                                        </button>
                                    </form>
                                </td>
                                <td>
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-sm btn-outline-info" data-bs-toggle="modal" data-bs-target="#detailModal<?= $event['id'] ?>">
                                            Detail
                                        </button>
                                        <a href="<?= $shareableUrl ?>" target="_blank" class="btn btn-sm btn-outline-primary">
                                            Lihat Halaman
                                        </a>
                                        <a href="index.php?page=add_promotion&event_id=<?= $event['id'] ?>" class="btn btn-sm btn-outline-success">
                                            Promosikan
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            
                            <!-- Detail Modal -->
                            <div class="modal fade" id="detailModal<?= $event['id'] ?>" tabindex="-1" aria-labelledby="detailModalLabel<?= $event['id'] ?>" aria-hidden="true">
                                <div class="modal-dialog modal-xl">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="detailModalLabel<?= $event['id'] ?>">Detail Event: <?= htmlspecialchars($event['name']) ?></h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <h6>Informasi Dasar</h6>
                                                    <div class="mb-2 row">
                                                        <div class="col-md-4"><strong>Penyelenggara:</strong></div>
                                                        <div class="col-md-8"><?= htmlspecialchars($organizerName) ?></div>
                                                    </div>
                                                    <div class="mb-2 row">
                                                        <div class="col-md-4"><strong>Waktu Pendaftaran:</strong></div>
                                                        <div class="col-md-8">
                                                            <?= date('d/m/Y', strtotime($event['registration_start'])) ?> - 
                                                            <?= date('d/m/Y', strtotime($event['registration_end'])) ?>
                                                        </div>
                                                    </div>
                                                    <div class="mb-2 row">
                                                        <div class="col-md-4"><strong>Waktu Pelaksanaan:</strong></div>
                                                        <div class="col-md-8">
                                                            <?= date('d/m/Y', strtotime($event['event_start'])) ?> - 
                                                            <?= date('d/m/Y', strtotime($event['event_end'])) ?>
                                                        </div>
                                                    </div>
                                                    <div class="mb-2 row">
                                                        <div class="col-md-4"><strong>Akses Penghargaan:</strong></div>
                                                        <div class="col-md-8"><?= date('d/m/Y', strtotime($event['award_access'])) ?></div>
                                                    </div>
                                                    <div class="mb-2 row">
                                                        <div class="col-md-4"><strong>Tanggal Sapu Bersih:</strong></div>
                                                        <div class="col-md-8"><?= date('d/m/Y', strtotime($event['cleanup_date'])) ?></div>
                                                    </div>
                                                    
                                                    <h6 class="mt-4">Pertanyaan/Ketentuan</h6>
                                                    <div class="p-3 bg-light rounded mb-3">
                                                        <?= nl2br(htmlspecialchars($event['questions'])) ?>
                                                    </div>
                                                    
                                                    <h6 class="mt-4">Deskripsi Event</h6>
                                                    <div class="p-3 bg-light rounded mb-3">
                                                        <?= nl2br(htmlspecialchars($event['description'])) ?>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <h6>Poster/Gambar Event</h6>
                                                    <?php if (!empty($event['images'])): ?>
                                                        <div id="eventImagesCarousel<?= $event['id'] ?>" class="carousel slide" data-bs-ride="carousel">
                                                            <div class="carousel-inner">
                                                                <?php foreach ($event['images'] as $index => $image): ?>
                                                                    <div class="carousel-item <?= $index === 0 ? 'active' : '' ?>">
                                                                        <img src="<?= htmlspecialchars($image) ?>" class="d-block w-100 event-poster" alt="Poster Event">
                                                                    </div>
                                                                <?php endforeach; ?>
                                                            </div>
                                                            <?php if (count($event['images']) > 1): ?>
                                                                <button class="carousel-control-prev" type="button" data-bs-target="#eventImagesCarousel<?= $event['id'] ?>" data-bs-slide="prev">
                                                                    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                                                                    <span class="visually-hidden">Previous</span>
                                                                </button>
                                                                <button class="carousel-control-next" type="button" data-bs-target="#eventImagesCarousel<?= $event['id'] ?>" data-bs-slide="next">
                                                                    <span class="carousel-control-next-icon" aria-hidden="true"></span>
                                                                    <span class="visually-hidden">Next</span>
                                                                </button>
                                                            <?php endif; ?>
                                                        </div>
                                                        
                                                        <div class="mt-3">
                                                            <?php foreach ($event['images'] as $index => $image): ?>
                                                                <a href="<?= htmlspecialchars($image) ?>" target="_blank" class="btn btn-sm btn-outline-primary mb-2 me-2">
                                                                    <i class="bi bi-download"></i> Unduh Gambar <?= $index + 1 ?>
                                                                </a>
                                                            <?php endforeach; ?>
                                                        </div>
                                                    <?php else: ?>
                                                        <div class="alert alert-info">Tidak ada gambar tersedia.</div>
                                                    <?php endif; ?>
                                                    
                                                    <h6 class="mt-4">Link Berbagi</h6>
                                                    <div class="input-group mb-3">
                                                        <input type="text" class="form-control share-link-input" value="<?= $shareableUrl ?>" readonly>
                                                        <button class="btn btn-outline-secondary copy-btn" type="button" data-copy="<?= $shareableUrl ?>">
                                                            <i class="bi bi-clipboard"></i> Salin
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                                            <a href="<?= $shareableUrl ?>" target="_blank" class="btn btn-primary">
                                                <i class="bi bi-box-arrow-up-right"></i> Buka Halaman Event
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php } ?>
    </div>
</div>