<?php
// API untuk mendapatkan data pelanggaran berdasarkan ID anggota
header('Content-Type: application/json');

// Fungsi untuk membaca data dari file JSON
function readJsonFile($filename) {
    $jsonData = file_get_contents($filename);
    return json_decode($jsonData, true);
}

// Cek apakah parameter ID anggota ada
if (isset($_GET['id_anggota'])) {
    $id_anggota = (int)$_GET['id_anggota'];
    
    // Baca data pelanggaran
    $pelanggaranData = readJsonFile('../data/pelanggaran.json');
    
    // Filter pelanggaran berdasarkan ID anggota
    $pelanggaran_anggota = [];
    foreach ($pelanggaranData['pelanggaran'] as $item) {
        if ($item['id_anggota'] === $id_anggota) {
            $pelanggaran_anggota[] = $item;
        }
    }
    
    // Kembalikan data pelanggaran anggota
    echo json_encode($pelanggaran_anggota);
} else {
    // Jika parameter ID anggota tidak ada, kembalikan error
    http_response_code(400);
    echo json_encode(['error' => 'Parameter ID anggota diperlukan']);
}
?>
