<?php
/**
 * Halaman tugas
 * 
 * Menampilkan dan mengelola tugas pengguna
 */

// Cek jika user belum login
if (!isLoggedIn()) {
    redirect('index.php');
}

// Username pengguna saat ini
$username = $_SESSION['username'];

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Tambah tugas baru
    if (isset($_POST['add_tugas'])) {
        $nomor = sanitize($_POST['nomor_tugas']);
        $tanggalDibuat = !empty($_POST['tanggal_dibuat_tugas']) ? $_POST['tanggal_dibuat_tugas'] : date('Y-m-d');
        $deadline = !empty($_POST['deadline_tugas']) ? $_POST['deadline_tugas'] : null;
        
        if (addTugas($db, $username, $nomor, $tanggalDibuat, $deadline)) {
            echo '<script>showToast("Tugas berhasil ditambahkan", "success");</script>';
        } else {
            echo '<script>showToast("Gagal menambahkan tugas", "error");</script>';
        }
    }
    
    // Update tugas
    else if (isset($_POST['update_tugas'])) {
        $tugasId = intval($_POST['tugas_id']);
        $nomor = sanitize($_POST['nomor_tugas']);
        $tanggalDibuat = !empty($_POST['tanggal_dibuat_tugas']) ? $_POST['tanggal_dibuat_tugas'] : date('Y-m-d');
        $deadline = !empty($_POST['deadline_tugas']) ? $_POST['deadline_tugas'] : null;
        
        if (updateTugas($db, $tugasId, $nomor, $tanggalDibuat, $deadline)) {
            echo '<script>showToast("Tugas berhasil diupdate", "success");</script>';
        } else {
            echo '<script>showToast("Gagal mengupdate tugas", "error");</script>';
        }
    }
    
    // Tandai selesai
    else if (isset($_POST['complete_tugas'])) {
        $tugasId = intval($_POST['tugas_id']);
        $mapelId = intval($_POST['mapel_id']);
        
        if (completeTugasMapel($db, $tugasId, $mapelId)) {
            echo '<script>showToast("Mata pelajaran ditandai selesai", "success");</script>';
            
            // Cek apakah semua mata pelajaran sudah selesai
            if (isTugasComplete($db, $tugasId)) {
                if (archiveTugas($db, $tugasId)) {
                    echo '<script>showToast("Semua mata pelajaran selesai! Tugas dipindahkan ke arsip.", "success");</script>';
                }
            }
        } else {
            echo '<script>showToast("Gagal menandai mata pelajaran", "error");</script>';
        }
    }
}

// Handle actions
if (isset($_GET['action'])) {
    // Hapus tugas
    if ($_GET['action'] === 'delete_tugas' && isset($_GET['id'])) {
        $tugasId = intval($_GET['id']);
        
        if (deleteTugas($db, $tugasId)) {
            echo '<script>showToast("Tugas berhasil dihapus", "success");</script>';
        } else {
            echo '<script>showToast("Gagal menghapus tugas", "error");</script>';
        }
    }
}

// Ambil data tugas pengguna
$tugas_list = getUserTugas($db, $username);

// Ambil data mata pelajaran
$mapel_list = getUserMapelNames($db, $username);
?>

<!-- Tugas Tab -->
<div class="tab-content active" id="tugas-content">
    <!-- Search box -->
    <div class="search-box">
        <input type="text" id="search-tugas" data-target="tugas-list" placeholder="Cari tugas...">
    </div>
    
    <div id="tugas-list">
        <?php if (empty($tugas_list)): ?>
            <div class="card">
                <div class="card-body">
                    <p>Belum ada tugas yang aktif.</p>
                    <button class="btn" onclick="openModal('add-tugas-modal')">
                        <i class="fas fa-plus"></i> Tambah Tugas Baru
                    </button>
                </div>
            </div>
        <?php else: ?>
            <?php foreach ($tugas_list as $tugas): ?>
                <div class="card tugas-card">
                    <div class="card-header">
                        <h3><?php echo $tugas['nomor']; ?></h3>
                        <div class="card-actions">
                            <button class="btn btn-sm" onclick="openModal('edit-tugas-modal-<?php echo $tugas['id']; ?>')">
                                <i class="fas fa-edit"></i>
                            </button>
                            <button class="btn btn-sm" onclick="openModal('tugas-modal-<?php echo $tugas['id']; ?>')">
                                <i class="fas fa-check"></i>
                            </button>
                            <button class="btn btn-sm btn-danger" data-delete="tugas" data-id="<?php echo $tugas['id']; ?>">
                                <i class="fas fa-trash"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="date-info">
                            <p><strong>Tanggal Dibuat:</strong> <?php echo isset($tugas['tanggal_dibuat']) ? formatDate($tugas['tanggal_dibuat']) : 'Tidak diatur'; ?></p>
                            <?php if (!empty($tugas['deadline'])): ?>
                                <p>
                                    <strong>Deadline:</strong> <?php echo formatDate($tugas['deadline']); ?>
                                    <?php
                                        if (!empty($tugas['deadline'])) {
                                            $days_left = hitungSisaHari($tugas['deadline']);
                                            $status = getDeadlineStatus($tugas['deadline']);
                                            echo '<span class="badge ' . $status['badge_class'] . '">' . $status['badge_text'] . '</span>';
                                        }
                                    ?>
                                </p>
                            <?php endif; ?>
                        </div>
                        
                        <!-- Progress bar -->
                        <div class="progress-container">
                            <small class="progress-count">Progres: <?php echo count($tugas['selesai']); ?> dari <?php echo $tugas['total_mapel']; ?> mata pelajaran</small>
                            <div class="progress-bar">
                                <div class="progress" style="width: <?php echo $tugas['total_mapel'] > 0 ? (count($tugas['selesai']) / $tugas['total_mapel'] * 100) : 0; ?>%"></div>
                            </div>
                        </div>
                        
                        <div>
                            <strong>Mata Pelajaran yang sudah selesai:</strong>
                            <div style="margin-top: 5px;">
                                <?php if (empty($tugas['selesai'])): ?>
                                    <p>Belum ada mata pelajaran yang selesai.</p>
                                <?php else: ?>
                                    <?php foreach ($tugas['selesai'] as $mapel): ?>
                                        <span class="badge badge-success"><?php echo $mapel['nama_mapel']; ?></span>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Tugas Completion Modal -->
                <div class="modal" id="tugas-modal-<?php echo $tugas['id']; ?>">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h2>Selesaikan <?php echo $tugas['nomor']; ?></h2>
                            <span class="close" onclick="closeModal('tugas-modal-<?php echo $tugas['id']; ?>')">&times;</span>
                        </div>
                        <div>
                            <p>Pilih mata pelajaran yang sudah selesai:</p>
                            <form method="post" action="">
                                <input type="hidden" name="tugas_id" value="<?php echo $tugas['id']; ?>">
                                
                                <div class="mapel-list">
                                    <?php 
                                    // Kumpulkan id mapel yang sudah selesai
                                    $selesai_ids = array_map(function($m) { return $m['id']; }, $tugas['selesai']);
                                    
                                    foreach ($mapel_list as $id => $nama_mapel): 
                                        $is_completed = in_array($id, $selesai_ids);
                                    ?>
                                        <div class="mapel-item">
                                            <label>
                                                <input type="radio" name="mapel_id" value="<?php echo $id; ?>" class="mapel-checkbox" required 
                                                    <?php echo $is_completed ? 'disabled checked' : ''; ?>>
                                                <?php echo $nama_mapel; ?>
                                                <?php if ($is_completed): ?>
                                                    <span class="badge badge-success">Selesai</span>
                                                <?php endif; ?>
                                            </label>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                                
                                <div class="action-buttons">
                                    <button type="button" onclick="closeModal('tugas-modal-<?php echo $tugas['id']; ?>')" class="btn-danger">Batal</button>
                                    <button type="submit" name="complete_tugas">Simpan</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                
                <!-- Edit Tugas Modal -->
                <div class="modal" id="edit-tugas-modal-<?php echo $tugas['id']; ?>">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h2>Edit Tugas</h2>
                            <span class="close" onclick="closeModal('edit-tugas-modal-<?php echo $tugas['id']; ?>')">&times;</span>
                        </div>
                        <div>
                            <form method="post" action="">
                                <input type="hidden" name="tugas_id" value="<?php echo $tugas['id']; ?>">
                                
                                <div class="form-group">
                                    <label for="nomor_tugas_<?php echo $tugas['id']; ?>">Nomor Tugas</label>
                                    <input type="text" id="nomor_tugas_<?php echo $tugas['id']; ?>" name="nomor_tugas" value="<?php echo $tugas['nomor']; ?>" required>
                                </div>
                                
                                <div class="form-group">
                                    <label for="tanggal_dibuat_tugas_<?php echo $tugas['id']; ?>">Tanggal Dibuat</label>
                                    <input type="date" id="tanggal_dibuat_tugas_<?php echo $tugas['id']; ?>" name="tanggal_dibuat_tugas" value="<?php echo $tugas['tanggal_dibuat']; ?>">
                                </div>
                                
                                <div class="form-group">
                                    <label for="deadline_tugas_<?php echo $tugas['id']; ?>">Deadline</label>
                                    <input type="date" id="deadline_tugas_<?php echo $tugas['id']; ?>" name="deadline_tugas" value="<?php echo $tugas['deadline']; ?>">
                                </div>
                                
                                <div class="action-buttons">
                                    <button type="button" onclick="closeModal('edit-tugas-modal-<?php echo $tugas['id']; ?>')" class="btn-danger">Batal</button>
                                    <button type="submit" name="update_tugas">Simpan</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
</div>

<!-- Add Tugas Modal -->
<div class="modal" id="add-tugas-modal">
    <div class="modal-content">
        <div class="modal-header">
            <h2>Tambah Tugas Baru</h2>
            <span class="close" onclick="closeModal('add-tugas-modal')">&times;</span>
        </div>
        <div>
            <form method="post" action="">
                <div class="form-group">
                    <label for="nomor_tugas">Nomor Tugas</label>
                    <input type="text" id="nomor_tugas" name="nomor_tugas" required placeholder="contoh: Tugas 1">
                </div>
                
                <div class="form-group">
                    <label for="tanggal_dibuat_tugas">Tanggal Dibuat</label>
                    <input type="date" id="tanggal_dibuat_tugas" name="tanggal_dibuat_tugas" value="<?php echo date('Y-m-d'); ?>">
                </div>
                
                <div class="form-group">
                    <label for="deadline_tugas">Deadline</label>
                    <input type="date" id="deadline_tugas" name="deadline_tugas">
                </div>
                
                <div class="action-buttons">
                    <button type="button" onclick="closeModal('add-tugas-modal')" class="btn-danger">Batal</button>
                    <button type="submit" name="add_tugas">Tambah</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Inisialisasi dialog konfirmasi hapus
    document.querySelectorAll('[data-delete="tugas"]').forEach(function(button) {
        button.addEventListener('click', function() {
            const id = this.getAttribute('data-id');
            confirmDelete('tugas', id);
        });
    });
});
</script>