<?php
/**
 * Halaman statistik
 * 
 * Menampilkan statistik dan item yang sudah selesai
 */

// Cek jika user belum login
if (!isLoggedIn()) {
    redirect('index.php');
}

// Username pengguna saat ini
$username = $_SESSION['username'];

// Ambil data statistik
$stats = getUserStats($db, $username);

// Ambil data diskusi yang sudah selesai
$diskusi_selesai = getUserDiskusiArchive($db, $username);

// Ambil data tugas yang sudah selesai
$tugas_selesai = getUserTugasArchive($db, $username);

// Ambil data baca yang sudah selesai
$baca_selesai = getUserBacaArchive($db, $username);
?>

<!-- Statistik Tab -->
<div class="tab-content active" id="statistik-content">
    <!-- Search box -->
    <div class="search-box">
        <input type="text" id="search-selesai" data-target="selesai-list" placeholder="Cari item selesai...">
    </div>
    
    <div id="selesai-list">
        <!-- Diskusi Selesai -->
        <h3>Diskusi Selesai</h3>
        <?php if (empty($diskusi_selesai)): ?>
            <div class="card">
                <div class="card-body">
                    <p>Belum ada diskusi yang selesai.</p>
                </div>
            </div>
        <?php else: ?>
            <?php foreach ($diskusi_selesai as $diskusi): ?>
                <div class="card">
                    <div class="card-header">
                        <h3><?php echo $diskusi['nomor']; ?></h3>
                        <span class="badge badge-success">Selesai</span>
                    </div>
                    <div class="card-body">
                        <div class="date-info">
                            <?php if (isset($diskusi['tanggal_dibuat'])): ?>
                                <p><strong>Tanggal Dibuat:</strong> <?php echo formatDate($diskusi['tanggal_dibuat']); ?></p>
                            <?php endif; ?>
                            <?php if (isset($diskusi['deadline'])): ?>
                                <p><strong>Deadline:</strong> <?php echo formatDate($diskusi['deadline']); ?></p>
                            <?php endif; ?>
                            <?php if (isset($diskusi['tanggal_selesai'])): ?>
                                <p><strong>Tanggal Selesai:</strong> <?php echo formatDate($diskusi['tanggal_selesai']); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
        
        <!-- Tugas Selesai -->
        <h3 style="margin-top: 20px;">Tugas Selesai</h3>
        <?php if (empty($tugas_selesai)): ?>
            <div class="card">
                <div class="card-body">
                    <p>Belum ada tugas yang selesai.</p>
                </div>
            </div>
        <?php else: ?>
            <?php foreach ($tugas_selesai as $tugas): ?>
                <div class="card">
                    <div class="card-header">
                        <h3><?php echo $tugas['nomor']; ?></h3>
                        <span class="badge badge-success">Selesai</span>
                    </div>
                    <div class="card-body">
                        <div class="date-info">
                            <?php if (isset($tugas['tanggal_dibuat'])): ?>
                                <p><strong>Tanggal Dibuat:</strong> <?php echo formatDate($tugas['tanggal_dibuat']); ?></p>
                            <?php endif; ?>
                            <?php if (isset($tugas['deadline'])): ?>
                                <p><strong>Deadline:</strong> <?php echo formatDate($tugas['deadline']); ?></p>
                            <?php endif; ?>
                            <?php if (isset($tugas['tanggal_selesai'])): ?>
                                <p><strong>Tanggal Selesai:</strong> <?php echo formatDate($tugas['tanggal_selesai']); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
        
        <!-- Baca Selesai -->
        <h3 style="margin-top: 20px;">Baca Selesai</h3>
        <?php if (empty($baca_selesai)): ?>
            <div class="card">
                <div class="card-body">
                    <p>Belum ada baca yang selesai.</p>
                </div>
            </div>
        <?php else: ?>
            <?php foreach ($baca_selesai as $baca): ?>
                <div class="card">
                    <div class="card-header">
                        <h3><?php echo $baca['nama_mapel']; ?></h3>
                        <span class="badge badge-success">Selesai</span>
                    </div>
                    <div class="card-body">
                        <p><strong>Jumlah Bab:</strong> <?php echo $baca['jumlah_bab']; ?></p>
                        <?php if (isset($baca['tanggal_selesai'])): ?>
                            <p><strong>Tanggal Selesai:</strong> <?php echo formatDate($baca['tanggal_selesai']); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
        
        <?php if (empty($diskusi_selesai) && empty($tugas_selesai) && empty($baca_selesai)): ?>
            <div class="card" style="margin-top: 20px;">
                <div class="card-body">
                    <div style="text-align: center; padding: 20px;">
                        <i class="fas fa-info-circle" style="font-size: 48px; color: var(--info-color);"></i>
                        <h3 style="margin-top: 10px;">Belum Ada Item yang Selesai</h3>
                        <p>Selesaikan tugas, diskusi, atau baca untuk melihat mereka di sini.</p>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Pastikan statistik card muncul di halaman ini di mobile
    const statsCard = document.getElementById('stats-card');
    if (statsCard && window.innerWidth <= 768) {
        statsCard.style.display = 'flex';
    }
});
</script>