// JavaScript functions for Tugasin application

// Function to show loading overlay
function showLoading() {
    document.getElementById('loading-overlay').style.display = 'flex';
}

// Function to hide loading overlay
function hideLoading() {
    document.getElementById('loading-overlay').style.display = 'none';
}

// Function to open modal
function openModal(modalId) {
    document.getElementById(modalId).style.display = 'block';
}

// Function to close modal
function closeModal(modalId) {
    document.getElementById(modalId).style.display = 'none';
}

// Function to confirm delete
function confirmDelete(action, index) {
    if (confirm('Apakah Anda yakin ingin menghapus item ini?')) {
        showLoading();
        window.location.href = `?${action}=${index}`;
    }
}

// Function to search items
function searchItems(inputId, listId) {
    const input = document.getElementById(inputId);
    const filter = input.value.toUpperCase();
    const list = document.getElementById(listId);
    const items = list.getElementsByClassName('card');
    
    for (let i = 0; i < items.length; i++) {
        const item = items[i];
        const text = item.textContent || item.innerText;
        if (text.toUpperCase().indexOf(filter) > -1) {
            item.style.display = "";
        } else {
            item.style.display = "none";
        }
    }
}

// Function to toggle custom color section
function toggleCustomColorSection() {
    const customSection = document.getElementById('custom-color-section');
    const themeSelect = document.getElementById('theme-select');
    
    if (themeSelect.value === 'custom') {
        customSection.style.display = 'block';
    } else {
        customSection.style.display = 'none';
    }
}

// Add event listeners when DOM is loaded
document.addEventListener('DOMContentLoaded', function() {
    // Hide loading overlay when page is loaded
    hideLoading();
    
    // Add event listeners for tab switching
    const desktopTabs = document.querySelectorAll('.desktop-tab');
    const mobileTabs = document.querySelectorAll('.mobile-tab');
    
    function switchTab(tabName) {
        // Hide all tab contents
        const tabContents = document.querySelectorAll('.tab-content');
        tabContents.forEach(content => {
            content.classList.remove('active');
        });
        
        // Show selected tab content
        const selectedContent = document.getElementById(tabName + '-content');
        if (selectedContent) {
            selectedContent.classList.add('active');
        }
        
        // Update active tab indicators
        desktopTabs.forEach(tab => {
            if (tab.getAttribute('data-tab') === tabName) {
                tab.classList.add('active');
            } else {
                tab.classList.remove('active');
            }
        });
        
        mobileTabs.forEach(tab => {
            if (tab.getAttribute('data-tab') === tabName) {
                tab.classList.add('active');
            } else {
                tab.classList.remove('active');
            }
        });
        
        // Update URL without reloading page
        history.pushState(null, null, `?tab=${tabName}`);
    }
    
    // Add click event to desktop tabs
    desktopTabs.forEach(tab => {
        tab.addEventListener('click', function() {
            const tabName = this.getAttribute('data-tab');
            switchTab(tabName);
        });
    });
    
    // Add click event to mobile tabs
    mobileTabs.forEach(tab => {
        tab.addEventListener('click', function() {
            const tabName = this.getAttribute('data-tab');
            switchTab(tabName);
        });
    });
    
    // Add event listener for FAB button
    const fabButton = document.getElementById('fab-button');
    if (fabButton) {
        fabButton.addEventListener('click', function() {
            const currentTab = document.querySelector('.tab-content.active').id.replace('-content', '');
            if (currentTab === 'diskusi') {
                openModal('add-diskusi-modal');
            } else if (currentTab === 'tugas') {
                openModal('add-tugas-modal');
            } else if (currentTab === 'baca') {
                openModal('add-baca-modal');
            }
        });
    }
    
    // Add event listener for theme selection
    const themeSelect = document.getElementById('theme-select');
    if (themeSelect) {
        themeSelect.addEventListener('change', toggleCustomColorSection);
        // Initialize custom color section visibility
        toggleCustomColorSection();
    }
});
