<?php
/**
 * Halaman pengaturan
 * 
 * Menampilkan dan mengelola pengaturan aplikasi
 */

// Cek jika user belum login
if (!isLoggedIn()) {
    redirect('index.php');
}

// Username pengguna saat ini
$username = $_SESSION['username'];
$is_super_admin = isSuperAdmin();

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Update daftar mata pelajaran
    if (isset($_POST['update_mapel'])) {
        $mapel_list = array_filter(explode("\n", trim($_POST['mapel_list'])), function($value) {
            return trim($value) !== '';
        });
        
        // Hapus semua mata pelajaran pengguna yang ada
        $stmt = $db->prepare("DELETE FROM mapel WHERE username = ?");
        $stmt->bind_param("s", $username);
        $stmt->execute();
        
        // Tambahkan mata pelajaran baru
        $success = true;
        foreach ($mapel_list as $mapel) {
            $mapel = trim($mapel);
            if (!empty($mapel)) {
                if (!addMapel($db, $username, $mapel)) {
                    $success = false;
                    break;
                }
            }
        }
        
        if ($success) {
            echo '<script>showToast("Daftar mata pelajaran berhasil diupdate", "success");</script>';
        } else {
            echo '<script>showToast("Gagal mengupdate daftar mata pelajaran", "error");</script>';
        }
    }
    
    // Update tema
    else if (isset($_POST['update_theme'])) {
        $theme = $_POST['theme'];
        
        if (updateUserTheme($db, $username, $theme)) {
            echo '<script>
                showToast("Tema berhasil diubah", "success");
                setTimeout(function() {
                    window.location.reload();
                }, 1000);
            </script>';
        } else {
            echo '<script>showToast("Gagal mengubah tema", "error");</script>';
        }
    }
    
    // Tambah tema kustom
    else if (isset($_POST['add_custom_theme'])) {
        $themeName = sanitize($_POST['theme_name']);
        $primaryColor = sanitize($_POST['primary_color']);
        $secondaryColor = sanitize($_POST['secondary_color']);
        $dangerColor = sanitize($_POST['danger_color']);
        $warningColor = sanitize($_POST['warning_color']);
        $infoColor = sanitize($_POST['info_color']);
        $darkColor = sanitize($_POST['dark_color']);
        $lightColor = sanitize($_POST['light_color']);
        $successColor = sanitize($_POST['success_color']);
        
        // Validasi input
        if (empty($themeName) || empty($primaryColor)) {
            echo '<script>showToast("Nama tema dan warna utama harus diisi", "error");</script>';
        } else {
            // Buat ID unik
            $themeId = 'custom_' . strtolower(preg_replace('/[^a-zA-Z0-9]/', '', $themeName)) . '_' . substr(md5(uniqid()), 0, 6);
            
            $colors = [
                'primary' => $primaryColor,
                'secondary' => !empty($secondaryColor) ? $secondaryColor : $primaryColor,
                'danger' => !empty($dangerColor) ? $dangerColor : '#f44336',
                'warning' => !empty($warningColor) ? $warningColor : '#ff9800',
                'info' => !empty($infoColor) ? $infoColor : '#2196F3',
                'dark' => !empty($darkColor) ? $darkColor : '#333',
                'light' => !empty($lightColor) ? $lightColor : '#f4f4f4',
                'success' => !empty($successColor) ? $successColor : '#4CAF50'
            ];
            
            if (addCustomTheme($db, $themeId, $themeName, $colors)) {
                // Set tema pengguna ke tema baru
                updateUserTheme($db, $username, $themeId);
                
                echo '<script>
                    showToast("Tema kustom berhasil ditambahkan", "success");
                    setTimeout(function() {
                        window.location.reload();
                    }, 1000);
                </script>';
            } else {
                echo '<script>showToast("Gagal menambahkan tema kustom", "error");</script>';
            }
        }
    }
    
    // Tambah pengguna baru (admin only)
    else if (isset($_POST['add_user']) && $is_super_admin) {
        $new_username = trim($_POST['new_username']);
        $new_password = trim($_POST['new_password']);
        $new_nama = trim($_POST['new_nama']);
        $new_nim = trim($_POST['new_nim']);
        $new_expires = !empty($_POST['new_expires']) ? $_POST['new_expires'] : null;
        
        if (!empty($new_username) && !empty($new_password) && !empty($new_nama) && !empty($new_nim)) {
            // Hash password
            $hashed_password = hashPassword($new_password);
            
            if (addUser($db, $new_username, $hashed_password, $new_nama, $new_nim, 'user', $new_expires)) {
                echo '<script>showToast("Pengguna baru berhasil ditambahkan", "success");</script>';
            } else {
                echo '<script>showToast("Gagal menambahkan pengguna baru", "error");</script>';
            }
        } else {
            echo '<script>showToast("Semua field harus diisi", "error");</script>';
        }
    }
}

// Handle actions
if (isset($_GET['action'])) {
    // Hapus pengguna (admin only)
    if ($_GET['action'] === 'delete_user' && $is_super_admin && isset($_GET['username'])) {
        $delete_username = $_GET['username'];
        
        if ($delete_username !== 'rizaldi') {
            if (deleteUser($db, $delete_username)) {
                echo '<script>showToast("Pengguna berhasil dihapus", "success");</script>';
            } else {
                echo '<script>showToast("Gagal menghapus pengguna", "error");</script>';
            }
        } else {
            echo '<script>showToast("Tidak dapat menghapus super admin", "error");</script>';
        }
    }
}

// Ambil data mata pelajaran pengguna
$mapel_list = getUserMapelNames($db, $username);

// Ambil data tema
$themes = getAllThemes($db);

// Tema pengguna saat ini
$user_theme = getUserTheme($db, $username);

// Ambil daftar pengguna (admin only)
$users = [];
if ($is_super_admin) {
    $users = getAllUsers($db);
}
?>

<!-- Pengaturan Tab -->
<div class="tab-content active" id="pengaturan-content">
    <!-- Daftar Mata Pelajaran -->
    <div class="card">
        <div class="card-header">
            <h3>Daftar Mata Pelajaran</h3>
        </div>
        <div class="card-body">
            <p>Ubah daftar mata pelajaran (satu baris untuk setiap mata pelajaran):</p>
            <form method="post" action="">
                <div class="form-group">
                    <textarea name="mapel_list" rows="8"><?php echo implode("\n", $mapel_list); ?></textarea>
                </div>
                <button type="submit" name="update_mapel">Simpan Perubahan</button>
            </form>
        </div>
    </div>
    
    <!-- Pengaturan Tema -->
    <div class="card">
        <div class="card-header">
            <h3>Pengaturan Tema</h3>
        </div>
        <div class="card-body">
            <p>Pilih tema aplikasi:</p>
            <form method="post" action="">
                <div class="theme-options">
                    <?php foreach ($themes as $theme): ?>
                        <div class="theme-option <?php echo $user_theme['id'] === $theme['id'] ? 'active' : ''; ?>" data-theme="<?php echo $theme['id']; ?>">
                            <div class="color-preview" style="background-color: <?php echo $theme['primary_color']; ?>;"></div>
                            <div><?php echo $theme['nama']; ?></div>
                        </div>
                    <?php endforeach; ?>
                    <input type="hidden" name="theme" id="selected-theme" value="<?php echo $user_theme['id']; ?>">
                </div>
                <button type="submit" name="update_theme" style="margin-top: 15px;">Terapkan Tema</button>
            </form>
        </div>
    </div>
    
    <!-- Tema Kustom -->
    <div class="card">
        <div class="card-header">
            <h3>Buat Tema Kustom</h3>
        </div>
        <div class="card-body">
            <form method="post" action="">
                <div class="form-group">
                    <label for="theme_name">Nama Tema</label>
                    <input type="text" id="theme_name" name="theme_name" required placeholder="Contoh: Tema Saya">
                </div>
                
                <div class="color-inputs">
                    <div class="color-input-group">
                        <label for="primary_color">Warna Utama</label>
                        <div class="color-input-wrapper">
                            <input type="color" id="primary_color" name="primary_color" value="#4CAF50">
                            <input type="text" value="#4CAF50" id="primary_color_text" onkeyup="document.getElementById('primary_color').value = this.value">
                        </div>
                    </div>
                    
                    <div class="color-input-group">
                        <label for="secondary_color">Warna Sekunder</label>
                        <div class="color-input-wrapper">
                            <input type="color" id="secondary_color" name="secondary_color" value="#45a049">
                            <input type="text" value="#45a049" id="secondary_color_text" onkeyup="document.getElementById('secondary_color').value = this.value">
                        </div>
                    </div>
                    
                    <div class="color-input-group">
                        <label for="danger_color">Warna Bahaya</label>
                        <div class="color-input-wrapper">
                            <input type="color" id="danger_color" name="danger_color" value="#f44336">
                            <input type="text" value="#f44336" id="danger_color_text" onkeyup="document.getElementById('danger_color').value = this.value">
                        </div>
                    </div>
                    
                    <div class="color-input-group">
                        <label for="warning_color">Warna Peringatan</label>
                        <div class="color-input-wrapper">
                            <input type="color" id="warning_color" name="warning_color" value="#ff9800">
                            <input type="text" value="#ff9800" id="warning_color_text" onkeyup="document.getElementById('warning_color').value = this.value">
                        </div>
                    </div>
                    
                    <div class="color-input-group">
                        <label for="info_color">Warna Info</label>
                        <div class="color-input-wrapper">
                            <input type="color" id="info_color" name="info_color" value="#2196F3">
                            <input type="text" value="#2196F3" id="info_color_text" onkeyup="document.getElementById('info_color').value = this.value">
                        </div>
                    </div>
                    
                    <div class="color-input-group">
                        <label for="success_color">Warna Sukses</label>
                        <div class="color-input-wrapper">
                            <input type="color" id="success_color" name="success_color" value="#4CAF50">
                            <input type="text" value="#4CAF50" id="success_color_text" onkeyup="document.getElementById('success_color').value = this.value">
                        </div>
                    </div>
                </div>
                
                <div style="margin-top: 20px;">
                    <label>Preview Tema:</label>
                    <div id="custom-theme-preview" style="height: 40px; border-radius: 4px; background-color: #4CAF50; margin-top: 5px;"></div>
                </div>
                
                <button type="submit" name="add_custom_theme" style="margin-top: 15px;">Buat Tema</button>
            </form>
        </div>
    </div>
    
    <!-- Menu Tambahan -->
    <div class="card">
        <div class="card-header">
            <h3>Menu</h3>
        </div>
        <div class="card-body">
            <div class="list-group">
                <a href="#" class="btn" style="margin-bottom: 10px; text-align: left;">
                    <i class="fas fa-envelope"></i> Masukkan
                </a>
                <a href="#" class="btn" style="margin-bottom: 10px; text-align: left;">
                    <i class="fas fa-bug"></i> Laporkan Bug
                </a>
                <a href="#" class="btn" style="margin-bottom: 10px; text-align: left;">
                    <i class="fas fa-info-circle"></i> Tentang
                </a>
            </div>
        </div>
    </div>
    
    <?php if ($is_super_admin): ?>
        <!-- Kelola Pengguna (admin only) -->
        <div class="card">
            <div class="card-header">
                <h3>Kelola Pengguna</h3>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table>
                        <thead>
                            <tr>
                                <th>Username</th>
                                <th>Nama</th>
                                <th>NIM</th>
                                <th>Kedaluwarsa</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($users as $user): ?>
                                <tr>
                                    <td><?php echo $user['username']; ?></td>
                                    <td><?php echo $user['nama']; ?></td>
                                    <td><?php echo $user['nim']; ?></td>
                                    <td><?php echo !empty($user['expires']) ? formatDate($user['expires']) : 'Tidak ada'; ?></td>
                                    <td>
                                        <?php if ($user['username'] !== 'rizaldi'): ?>
                                            <a href="?action=delete_user&username=<?php echo $user['username']; ?>&tab=pengaturan" class="btn btn-sm btn-danger" onclick="return confirm('Yakin ingin menghapus pengguna ini?')">Hapus</a>
                                        <?php else: ?>
                                            <span class="badge badge-info">Super Admin</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                
                <div style="margin-top: 20px;">
                    <h4>Tambah Pengguna Baru</h4>
                    <form method="post" action="">
                        <div class="form-group">
                            <label for="new_username">Username</label>
                            <input type="text" id="new_username" name="new_username" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="new_password">Password</label>
                            <input type="password" id="new_password" name="new_password" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="new_nama">Nama Lengkap</label>
                            <input type="text" id="new_nama" name="new_nama" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="new_nim">NIM</label>
                            <input type="text" id="new_nim" name="new_nim" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="new_expires">Kedaluarsa (opsional)</label>
                            <input type="date" id="new_expires" name="new_expires">
                        </div>
                        
                        <button type="submit" name="add_user">Tambah Pengguna</button>
                    </form>
                </div>
            </div>
        </div>
    <?php endif; ?>
    
    <!-- Mobile Logout Button -->
    <div class="card" id="mobile-logout-card" style="display: none;">
        <div class="card-body">
            <a href="?logout=1" class="btn btn-danger" style="width: 100%;">Logout</a>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Inisialisasi pemilihan tema
    document.querySelectorAll('.theme-option').forEach(function(option) {
        option.addEventListener('click', function() {
            const theme = this.getAttribute('data-theme');
            document.querySelectorAll('.theme-option').forEach(function(opt) {
                opt.classList.remove('active');
            });
            this.classList.add('active');
            document.getElementById('selected-theme').value = theme;
        });
    });
    
    // Update color text inputs when color pickers change
    document.querySelectorAll('input[type="color"]').forEach(function(input) {
        input.addEventListener('input', function() {
            const textId = this.id + '_text';
            const textInput = document.getElementById(textId);
            if (textInput) {
                textInput.value = this.value;
            }
            
            // Update preview if primary color
            if (this.id === 'primary_color') {
                document.getElementById('custom-theme-preview').style.backgroundColor = this.value;
            }
        });
    });
    
    // Update color pickers when text inputs change
    document.querySelectorAll('.color-input-wrapper input[type="text"]').forEach(function(input) {
        input.addEventListener('input', function() {
            const colorId = this.id.replace('_text', '');
            const colorInput = document.getElementById(colorId);
            if (colorInput && /^#[0-9A-F]{6}$/i.test(this.value)) {
                colorInput.value = this.value;
                
                // Update preview if primary color
                if (colorId === 'primary_color') {
                    document.getElementById('custom-theme-preview').style.backgroundColor = this.value;
                }
            }
        });
    });
    
    // Show/hide mobile logout button based on screen size
    function handleMobileLogout() {
        const mobileLogoutCard = document.getElementById('mobile-logout-card');
        if (mobileLogoutCard) {
            if (window.innerWidth <= 768) {
                mobileLogoutCard.style.display = 'block';
            } else {
                mobileLogoutCard.style.display = 'none';
            }
        }
    }
    
    // Initial call
    handleMobileLogout();
    
    // Add event listener for window resize
    window.addEventListener('resize', handleMobileLogout);
});
</script>