<?php
// Aplikasi Pengelola Akun WhatsApp
// Menyimpan data di JSON file

// Inisialisasi session
session_start();

// File JSON untuk penyimpanan data
$json_file = 'data.json';

// Fungsi untuk mendapatkan data dari file JSON
function getData() {
    global $json_file;
    if (file_exists($json_file)) {
        $json_data = file_get_contents($json_file);
        return json_decode($json_data, true);
    } else {
        // Jika file tidak ada, buat struktur data default
        $default_data = [
            'accounts' => [],
            'phones' => [],
            'sims' => []
        ];
        file_put_contents($json_file, json_encode($default_data, JSON_PRETTY_PRINT));
        return $default_data;
    }
}

// Fungsi untuk menyimpan data ke file JSON
function saveData($data) {
    global $json_file;
    file_put_contents($json_file, json_encode($data, JSON_PRETTY_PRINT));
}

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = getData();
    
    // Tambah atau Edit Akun WA
    if (isset($_POST['action']) && ($_POST['action'] === 'add_account' || $_POST['action'] === 'edit_account')) {
        $account = [
            'id' => isset($_POST['id']) ? $_POST['id'] : uniqid(),
            'name' => $_POST['name'],
            'number' => $_POST['number'],
            'phone_id' => $_POST['phone_id'],
            'sim_id' => $_POST['sim_id'],
            'recovery_email' => $_POST['recovery_email']
        ];
        
        if ($_POST['action'] === 'add_account') {
            $data['accounts'][] = $account;
            $_SESSION['message'] = 'Akun WhatsApp berhasil ditambahkan!';
        } else {
            // Update akun yang sudah ada
            foreach ($data['accounts'] as $key => $existing_account) {
                if ($existing_account['id'] === $account['id']) {
                    $data['accounts'][$key] = $account;
                    break;
                }
            }
            $_SESSION['message'] = 'Akun WhatsApp berhasil diperbarui!';
        }
        saveData($data);
        header('Location: ' . $_SERVER['PHP_SELF']);
        exit;
    }
    
    // Hapus Akun WA
    if (isset($_POST['action']) && $_POST['action'] === 'delete_account') {
        $id = $_POST['id'];
        $accounts = [];
        foreach ($data['accounts'] as $account) {
            if ($account['id'] !== $id) {
                $accounts[] = $account;
            }
        }
        $data['accounts'] = $accounts;
        saveData($data);
        $_SESSION['message'] = 'Akun WhatsApp berhasil dihapus!';
        header('Location: ' . $_SERVER['PHP_SELF']);
        exit;
    }
    
    // Tambah atau Edit HP
    if (isset($_POST['action']) && ($_POST['action'] === 'add_phone' || $_POST['action'] === 'edit_phone')) {
        $phone = [
            'id' => isset($_POST['id']) ? $_POST['id'] : uniqid(),
            'name' => $_POST['phone_name'],
            'quality' => $_POST['phone_quality']
        ];
        
        if ($_POST['action'] === 'add_phone') {
            $data['phones'][] = $phone;
            $_SESSION['message'] = 'HP berhasil ditambahkan!';
        } else {
            // Update HP yang sudah ada
            foreach ($data['phones'] as $key => $existing_phone) {
                if ($existing_phone['id'] === $phone['id']) {
                    $data['phones'][$key] = $phone;
                    break;
                }
            }
            $_SESSION['message'] = 'Data HP berhasil diperbarui!';
        }
        saveData($data);
        header('Location: ' . $_SERVER['PHP_SELF'] . '?tab=phones');
        exit;
    }
    
    // Hapus HP
    if (isset($_POST['action']) && $_POST['action'] === 'delete_phone') {
        $id = $_POST['id'];
        $phones = [];
        foreach ($data['phones'] as $phone) {
            if ($phone['id'] !== $id) {
                $phones[] = $phone;
            }
        }
        $data['phones'] = $phones;
        saveData($data);
        $_SESSION['message'] = 'Data HP berhasil dihapus!';
        header('Location: ' . $_SERVER['PHP_SELF'] . '?tab=phones');
        exit;
    }
    
    // Tambah atau Edit SIM
    if (isset($_POST['action']) && ($_POST['action'] === 'add_sim' || $_POST['action'] === 'edit_sim')) {
        $sim = [
            'id' => isset($_POST['id']) ? $_POST['id'] : uniqid(),
            'name' => $_POST['sim_name'],
            'provider' => $_POST['sim_provider']
        ];
        
        if ($_POST['action'] === 'add_sim') {
            $data['sims'][] = $sim;
            $_SESSION['message'] = 'SIM berhasil ditambahkan!';
        } else {
            // Update SIM yang sudah ada
            foreach ($data['sims'] as $key => $existing_sim) {
                if ($existing_sim['id'] === $sim['id']) {
                    $data['sims'][$key] = $sim;
                    break;
                }
            }
            $_SESSION['message'] = 'Data SIM berhasil diperbarui!';
        }
        saveData($data);
        header('Location: ' . $_SERVER['PHP_SELF'] . '?tab=sims');
        exit;
    }
    
    // Hapus SIM
    if (isset($_POST['action']) && $_POST['action'] === 'delete_sim') {
        $id = $_POST['id'];
        $sims = [];
        foreach ($data['sims'] as $sim) {
            if ($sim['id'] !== $id) {
                $sims[] = $sim;
            }
        }
        $data['sims'] = $sims;
        saveData($data);
        $_SESSION['message'] = 'Data SIM berhasil dihapus!';
        header('Location: ' . $_SERVER['PHP_SELF'] . '?tab=sims');
        exit;
    }
}

// Mendapatkan data untuk ditampilkan
$data = getData();
$tab = isset($_GET['tab']) ? $_GET['tab'] : 'accounts';
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pengelola Akun WhatsApp</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #25D366;
            --secondary-color: #128C7E;
            --dark-color: #075E54;
            --light-color: #ECE5DD;
            --danger-color: #FF5252;
            --success-color: #4CAF50;
            --warning-color: #FFC107;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            background-color: #f4f4f9;
            color: #333;
            line-height: 1.6;
        }
        
        .container {
            width: 100%;
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }
        
        header {
            background-color: var(--primary-color);
            color: white;
            padding: 20px 0;
            margin-bottom: 30px;
            text-align: center;
            border-radius: 0 0 10px 10px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            display: flex;
            flex-direction: column;
            align-items: center;
        }
        
        .logo {
            margin-bottom: 15px;
            width: 80px;
            height: 80px;
        }
        
        h1 {
            font-size: 2em;
            margin-bottom: 10px;
        }
        
        .tabs {
            display: flex;
            justify-content: center;
            gap: 10px;
            margin-bottom: 20px;
        }
        
        .tab-button {
            background-color: var(--secondary-color);
            color: white;
            border: none;
            padding: 10px 20px;
            cursor: pointer;
            border-radius: 5px;
            font-size: 16px;
            transition: background-color 0.3s;
        }
        
        .tab-button:hover {
            background-color: var(--dark-color);
        }
        
        .tab-button.active {
            background-color: var(--dark-color);
            font-weight: bold;
        }
        
        .card {
            background-color: white;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            padding: 20px;
            margin-bottom: 20px;
        }
        
        .card-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
            padding-bottom: 10px;
            border-bottom: 1px solid #eee;
        }
        
        .card-header h2 {
            color: var(--dark-color);
        }
        
        .btn {
            padding: 8px 15px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
            display: inline-flex;
            align-items: center;
            gap: 5px;
            transition: background-color 0.3s, transform 0.1s;
        }
        
        .btn:hover {
            transform: translateY(-2px);
        }
        
        .btn-primary {
            background-color: var(--primary-color);
            color: white;
        }
        
        .btn-primary:hover {
            background-color: var(--secondary-color);
        }
        
        .btn-danger {
            background-color: var(--danger-color);
            color: white;
        }
        
        .btn-danger:hover {
            background-color: #e53935;
        }
        
        .btn-warning {
            background-color: var(--warning-color);
            color: white;
        }
        
        .btn-warning:hover {
            background-color: #FFB300;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        
        th, td {
            padding: 12px 15px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }
        
        th {
            background-color: var(--light-color);
            color: var(--dark-color);
            font-weight: bold;
        }
        
        tr:hover {
            background-color: #f9f9f9;
        }
        
        .action-buttons {
            display: flex;
            gap: 8px;
        }
        
        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgba(0, 0, 0, 0.5);
            transition: all 0.3s ease;
        }
        
        .modal-content {
            background-color: #fff;
            margin: 10% auto;
            padding: 20px;
            border-radius: 8px;
            width: 60%;
            max-width: 500px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
            transform: translateY(-20px);
            transition: transform 0.3s;
            animation: slideDown 0.3s forwards;
        }
        
        @keyframes slideDown {
            from {
                transform: translateY(-50px);
                opacity: 0;
            }
            to {
                transform: translateY(0);
                opacity: 1;
            }
        }
        
        .modal-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 1px solid #eee;
        }
        
        .close {
            color: #aaa;
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
            transition: color 0.3s;
        }
        
        .close:hover {
            color: var(--dark-color);
        }
        
        .form-group {
            margin-bottom: 15px;
        }
        
        label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
            color: #555;
        }
        
        input, select {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 16px;
        }
        
        input:focus, select:focus {
            border-color: var(--primary-color);
            outline: none;
            box-shadow: 0 0 0 2px rgba(37, 211, 102, 0.2);
        }
        
        .message {
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 5px;
            text-align: center;
            font-weight: bold;
        }
        
        .message-success {
            background-color: rgba(76, 175, 80, 0.1);
            color: var(--success-color);
            border: 1px solid var(--success-color);
        }
        
        .empty-state {
            text-align: center;
            padding: 40px 0;
            color: #999;
        }
        
        .empty-state i {
            font-size: 50px;
            margin-bottom: 15px;
            color: #ccc;
        }
        
        .loading {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(255, 255, 255, 0.8);
            z-index: 2000;
            justify-content: center;
            align-items: center;
        }
        
        .spinner {
            width: 60px;
            height: 60px;
            border: 8px solid #f3f3f3;
            border-top: 8px solid var(--primary-color);
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        /* Responsive styles */
        @media (max-width: 768px) {
            .modal-content {
                width: 90%;
                margin: 20% auto;
            }
            
            .tabs {
                flex-direction: column;
                gap: 5px;
            }
            
            .tab-button {
                width: 100%;
            }
            
            table {
                font-size: 14px;
            }
            
            th, td {
                padding: 8px 10px;
            }
            
            .action-buttons {
                flex-direction: column;
                gap: 5px;
            }
            
            .btn {
                width: 100%;
                justify-content: center;
            }
        }
    </style>
</head>
<body>
    <!-- Loading animation -->
    <div class="loading" id="loading">
        <div class="spinner"></div>
    </div>

    <div class="container">
        <header>
        <svg class="logo" viewBox="0 0 100 100" xmlns="http://www.w3.org/2000/svg">
            <circle cx="50" cy="50" r="45" fill="white"/>
            <path d="M50 20C33.4 20 20 33.4 20 50C20 56.6 22.1 62.7 25.7 67.7L22 78L32.5 74.4C37.4 77.6 43.5 79.5 50 79.5C66.6 79.5 80 66.1 80 49.5C80 33.4 66.6 20 50 20ZM63.8 62.5C63.3 63.7 61.6 64.9 60.1 65.2C58.6 65.5 56.8 65.6 55.2 65.1C54.1 64.7 52.2 64.2 50.2 63.3C42.8 60.1 38 52.6 37.7 52.1C37.4 51.6 35 48.4 35 45.1C35 41.8 36.7 40.2 37.3 39.5C37.9 38.8 38.6 38.6 39 38.6C39.4 38.6 39.9 38.6 40.3 38.7C40.7 38.8 41.3 38.6 41.8 40C42.4 41.4 43.8 44.7 44 45.2C44.2 45.7 44.2 46.2 44 46.6C43.8 47 43.5 47.5 43.1 47.9C42.7 48.3 42.3 48.8 42 49.1C41.7 49.4 41.3 49.8 41.8 50.6C42.3 51.4 43.8 53.9 46.1 56C49 58.7 51.5 59.5 52.4 59.8C53.3 60.1 53.8 60 54.2 59.5C54.6 59 56 57.3 56.5 56.5C57 55.7 57.5 55.8 58.2 56.1C58.9 56.4 62.2 57.9 63 58.3C63.8 58.7 64.3 58.8 64.5 59.1C64.7 59.7 64.3 61.2 63.8 62.5Z" fill="#25D366"/>
        </svg>
            <h1>Pengelola Akun WhatsApp</h1>
        </header>
        
        <?php if(isset($_SESSION['message'])): ?>
            <div class="message message-success">
                <?php echo $_SESSION['message']; ?>
                <?php unset($_SESSION['message']); ?>
            </div>
        <?php endif; ?>
        
        <div class="tabs">
            <button class="tab-button <?php echo $tab === 'accounts' ? 'active' : ''; ?>" onclick="window.location.href='?tab=accounts'">
                <i class="fas fa-address-book"></i> Akun WhatsApp
            </button>
            <button class="tab-button <?php echo $tab === 'phones' ? 'active' : ''; ?>" onclick="window.location.href='?tab=phones'">
                <i class="fas fa-mobile-alt"></i> Daftar HP
            </button>
            <button class="tab-button <?php echo $tab === 'sims' ? 'active' : ''; ?>" onclick="window.location.href='?tab=sims'">
                <i class="fas fa-sim-card"></i> Daftar SIM
            </button>
        </div>
        
        <?php if($tab === 'accounts'): ?>
            <div class="card">
                <div class="card-header">
                    <h2><i class="fab fa-whatsapp"></i> Daftar Akun WhatsApp</h2>
                    <button class="btn btn-primary" onclick="openModal('accountModal')">
                        <i class="fas fa-plus"></i> Tambah Akun
                    </button>
                </div>
                
                <?php if(empty($data['accounts'])): ?>
                    <div class="empty-state">
                        <i class="fas fa-address-book"></i>
                        <p>Belum ada akun WhatsApp yang tersimpan.</p>
                        <p>Klik "Tambah Akun" untuk mulai menambahkan.</p>
                    </div>
                <?php else: ?>
                    <table>
                        <thead>
                            <tr>
                                <th>Nama</th>
                                <th>Nomor</th>
                                <th>HP</th>
                                <th>SIM</th>
                                <th>Email Recovery</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($data['accounts'] as $account): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($account['name']); ?></td>
                                    <td><?php echo htmlspecialchars($account['number']); ?></td>
                                    <td>
                                        <?php 
                                        $phone_name = "Tidak diketahui";
                                        foreach($data['phones'] as $phone) {
                                            if($phone['id'] === $account['phone_id']) {
                                                $phone_name = $phone['name'];
                                                break;
                                            }
                                        }
                                        echo htmlspecialchars($phone_name);
                                        ?>
                                    </td>
                                    <td>
                                        <?php 
                                        $sim_name = "Tidak diketahui";
                                        foreach($data['sims'] as $sim) {
                                            if($sim['id'] === $account['sim_id']) {
                                                $sim_name = $sim['name'];
                                                break;
                                            }
                                        }
                                        echo htmlspecialchars($sim_name);
                                        ?>
                                    </td>
                                    <td><?php echo htmlspecialchars($account['recovery_email']); ?></td>
                                    <td class="action-buttons">
                                        <button class="btn btn-warning" onclick="editAccount('<?php echo $account['id']; ?>')">
                                            <i class="fas fa-edit"></i> Edit
                                        </button>
                                        <form method="post" onsubmit="return confirm('Apakah Anda yakin ingin menghapus akun ini?');">
                                            <input type="hidden" name="action" value="delete_account">
                                            <input type="hidden" name="id" value="<?php echo $account['id']; ?>">
                                            <button type="submit" class="btn btn-danger">
                                                <i class="fas fa-trash-alt"></i> Hapus
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php endif; ?>
            </div>

        <?php elseif($tab === 'phones'): ?>
            <div class="card">
                <div class="card-header">
                    <h2><i class="fas fa-mobile-alt"></i> Daftar HP</h2>
                    <button class="btn btn-primary" onclick="openModal('phoneModal')">
                        <i class="fas fa-plus"></i> Tambah HP
                    </button>
                </div>
                
                <?php if(empty($data['phones'])): ?>
                    <div class="empty-state">
                        <i class="fas fa-mobile-alt"></i>
                        <p>Belum ada data HP yang tersimpan.</p>
                        <p>Klik "Tambah HP" untuk mulai menambahkan.</p>
                    </div>
                <?php else: ?>
                    <table>
                        <thead>
                            <tr>
                                <th>Nama HP</th>
                                <th>Kualitas</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($data['phones'] as $phone): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($phone['name']); ?></td>
                                    <td>
                                        <?php 
                                        $quality_class = '';
                                        $quality_icon = '';
                                        
                                        if($phone['quality'] === 'bagus') {
                                            $quality_class = 'success-color';
                                            $quality_icon = 'fa-thumbs-up';
                                        } elseif($phone['quality'] === 'kurang_bagus') {
                                            $quality_class = 'warning-color';
                                            $quality_icon = 'fa-meh';
                                        } else {
                                            $quality_class = 'danger-color';
                                            $quality_icon = 'fa-thumbs-down';
                                        }
                                        ?>
                                        <span style="color: var(--<?php echo $quality_class; ?>)">
                                            <i class="fas <?php echo $quality_icon; ?>"></i> 
                                            <?php echo $phone['quality'] === 'bagus' ? 'Bagus' : 'Kurang Bagus'; ?>
                                        </span>
                                    </td>
                                    <td class="action-buttons">
                                        <button class="btn btn-warning" onclick="editPhone('<?php echo $phone['id']; ?>')">
                                            <i class="fas fa-edit"></i> Edit
                                        </button>
                                        <form method="post" onsubmit="return confirm('Apakah Anda yakin ingin menghapus data HP ini?');">
                                            <input type="hidden" name="action" value="delete_phone">
                                            <input type="hidden" name="id" value="<?php echo $phone['id']; ?>">
                                            <button type="submit" class="btn btn-danger">
                                                <i class="fas fa-trash-alt"></i> Hapus
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php endif; ?>
            </div>
            
        <?php elseif($tab === 'sims'): ?>
            <div class="card">
                <div class="card-header">
                    <h2><i class="fas fa-sim-card"></i> Daftar SIM</h2>
                    <button class="btn btn-primary" onclick="openModal('simModal')">
                        <i class="fas fa-plus"></i> Tambah SIM
                    </button>
                </div>
                
                <?php if(empty($data['sims'])): ?>
                    <div class="empty-state">
                        <i class="fas fa-sim-card"></i>
                        <p>Belum ada data SIM yang tersimpan.</p>
                        <p>Klik "Tambah SIM" untuk mulai menambahkan.</p>
                    </div>
                <?php else: ?>
                    <table>
                        <thead>
                            <tr>
                                <th>Nama SIM</th>
                                <th>Provider</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($data['sims'] as $sim): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($sim['name']); ?></td>
                                    <td><?php echo htmlspecialchars($sim['provider']); ?></td>
                                    <td class="action-buttons">
                                        <button class="btn btn-warning" onclick="editSim('<?php echo $sim['id']; ?>')">
                                            <i class="fas fa-edit"></i> Edit
                                        </button>
                                        <form method="post" onsubmit="return confirm('Apakah Anda yakin ingin menghapus data SIM ini?');">
                                            <input type="hidden" name="action" value="delete_sim">
                                            <input type="hidden" name="id" value="<?php echo $sim['id']; ?>">
                                            <button type="submit" class="btn btn-danger">
                                                <i class="fas fa-trash-alt"></i> Hapus
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
    
    <!-- Modal Tambah/Edit Akun WA -->
    <div id="accountModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 id="accountModalTitle">Tambah Akun WhatsApp</h3>
                <span class="close" onclick="closeModal('accountModal')">&times;</span>
            </div>
            <form id="accountForm" method="post">
                <input type="hidden" id="account_id" name="id">
                <input type="hidden" id="account_action" name="action" value="add_account">
                
                <div class="form-group">
                    <label for="name">Nama:</label>
                    <input type="text" id="name" name="name" required>
                </div>
                
                <div class="form-group">
                    <label for="number">Nomor WhatsApp:</label>
                    <input type="text" id="number" name="number" required placeholder="ex: 628123456789">
                </div>
                
                <div class="form-group">
                    <label for="phone_id">HP:</label>
                    <select id="phone_id" name="phone_id" required>
                        <option value="">- Pilih HP -</option>
                        <?php foreach($data['phones'] as $phone): ?>
                            <option value="<?php echo $phone['id']; ?>"><?php echo htmlspecialchars($phone['name']); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div class="form-group">
                    <label for="sim_id">SIM:</label>
                    <select id="sim_id" name="sim_id" required>
                        <option value="">- Pilih SIM -</option>
                        <?php foreach($data['sims'] as $sim): ?>
                            <option value="<?php echo $sim['id']; ?>"><?php echo htmlspecialchars($sim['name']); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div class="form-group">
                    <label for="recovery_email">Email Recovery:</label>
                    <input type="email" id="recovery_email" name="recovery_email" required>
                </div>
                
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Simpan
                </button>
            </form>
        </div>
    </div>
    
    <!-- Modal Tambah/Edit HP -->
    <div id="phoneModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 id="phoneModalTitle">Tambah HP</h3>
                <span class="close" onclick="closeModal('phoneModal')">&times;</span>
            </div>
            <form id="phoneForm" method="post">
                <input type="hidden" id="phone_id" name="id">
                <input type="hidden" id="phone_action" name="action" value="add_phone">
                
                <div class="form-group">
                    <label for="phone_name">Nama HP:</label>
                    <input type="text" id="phone_name" name="phone_name" required>
                </div>
                
                <div class="form-group">
                    <label for="phone_quality">Kualitas:</label>
                    <select id="phone_quality" name="phone_quality" required>
                        <option value="">- Pilih Kualitas -</option>
                        <option value="bagus">Bagus</option>
                        <option value="kurang_bagus">Kurang Bagus</option>
                    </select>
                </div>
                
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Simpan
                </button>
            </form>
        </div>
    </div>
    
    <!-- Modal Tambah/Edit SIM -->
    <div id="simModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 id="simModalTitle">Tambah SIM</h3>
                <span class="close" onclick="closeModal('simModal')">&times;</span>
            </div>
            <form id="simForm" method="post">
                <input type="hidden" id="sim_id" name="id">
                <input type="hidden" id="sim_action" name="action" value="add_sim">
                
                <div class="form-group">
                    <label for="sim_name">Nama SIM:</label>
                    <input type="text" id="sim_name" name="sim_name" required placeholder="ex: SIM 1, SIM 2, etc.">
                </div>
                
                <div class="form-group">
                    <label for="sim_provider">Provider:</label>
                    <input type="text" id="sim_provider" name="sim_provider" required placeholder="ex: Telkomsel, XL, Indosat, etc.">
                </div>
                
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Simpan
                </button>
            </form>
        </div>
    </div>
    
    <script>
        // Fungsi untuk menampilkan loading animation
        function showLoading() {
            document.getElementById('loading').style.display = 'flex';
        }
        
        // Fungsi untuk menyembunyikan loading animation
        function hideLoading() {
            document.getElementById('loading').style.display = 'none';
        }
        
        // Simulasi loading saat halaman pertama kali dimuat
        window.addEventListener('load', function() {
            showLoading();
            setTimeout(function() {
                hideLoading();
            }, 500);
        });
        
        // Tambahkan event listener ke semua form untuk menampilkan loading
        document.querySelectorAll('form').forEach(form => {
            form.addEventListener('submit', function() {
                showLoading();
            });
        });
        
        // Fungsi untuk membuka modal
        function openModal(modalId) {
            document.getElementById(modalId).style.display = 'block';
        }
        
        // Fungsi untuk menutup modal
        function closeModal(modalId) {
            document.getElementById(modalId).style.display = 'none';
        }
        
        // Menutup modal saat mengklik di luar modal
        window.onclick = function(event) {
            if (event.target.className === 'modal') {
                event.target.style.display = 'none';
            }
        }
        
        // Fungsi untuk edit akun
        function editAccount(id) {
            // Reset form
            document.getElementById('accountForm').reset();
            
            // Ubah judul dan action
            document.getElementById('accountModalTitle').innerText = 'Edit Akun WhatsApp';
            document.getElementById('account_action').value = 'edit_account';
            
            // Ambil data akun yang akan diedit
            let accounts = <?php echo json_encode($data['accounts']); ?>;
            let account = accounts.find(account => account.id === id);
            
            // Isi form dengan data akun
            document.getElementById('account_id').value = account.id;
            document.getElementById('name').value = account.name;
            document.getElementById('number').value = account.number;
            document.getElementById('phone_id').value = account.phone_id;
            document.getElementById('sim_id').value = account.sim_id;
            document.getElementById('recovery_email').value = account.recovery_email;
            
            // Tampilkan modal
            openModal('accountModal');
        }
        
        // Fungsi untuk edit HP
        function editPhone(id) {
            // Reset form
            document.getElementById('phoneForm').reset();
            
            // Ubah judul dan action
            document.getElementById('phoneModalTitle').innerText = 'Edit HP';
            document.getElementById('phone_action').value = 'edit_phone';
            
            // Ambil data HP yang akan diedit
            let phones = <?php echo json_encode($data['phones']); ?>;
            let phone = phones.find(phone => phone.id === id);
            
            // Isi form dengan data HP
            document.getElementById('phone_id').value = phone.id;
            document.getElementById('phone_name').value = phone.name;
            document.getElementById('phone_quality').value = phone.quality;
            
            // Tampilkan modal
            openModal('phoneModal');
        }
        
        // Fungsi untuk edit SIM
        function editSim(id) {
            // Reset form
            document.getElementById('simForm').reset();
            
            // Ubah judul dan action
            document.getElementById('simModalTitle').innerText = 'Edit SIM';
            document.getElementById('sim_action').value = 'edit_sim';
            
            // Ambil data SIM yang akan diedit
            let sims = <?php echo json_encode($data['sims']); ?>;
            let sim = sims.find(sim => sim.id === id);
            
            // Isi form dengan data SIM
            document.getElementById('sim_id').value = sim.id;
            document.getElementById('sim_name').value = sim.name;
            document.getElementById('sim_provider').value = sim.provider;
            
            // Tampilkan modal
            openModal('simModal');
        }
        
        // Animasi untuk pesan sukses
        setTimeout(function() {
            const messageElement = document.querySelector('.message');
            if (messageElement) {
                messageElement.style.opacity = '0';
                messageElement.style.transition = 'opacity 1s ease';
                setTimeout(function() {
                    messageElement.style.display = 'none';
                }, 1000);
            }
        }, 3000);
    </script>
</body>
</html>