<?php
// index.php - Halaman Login
session_start();

// Check if already logged in
if (isset($_SESSION['logged_in']) && $_SESSION['logged_in'] === true) {
    header('Location: dashboard.php');
    exit;
}

// Process login
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $pin = $_POST['pin'] ?? '';
    
    // Check PIN
    if ($pin === '051205') {
        $_SESSION['logged_in'] = true;
        header('Location: dashboard.php');
        exit;
    } else {
        $error = 'PIN tidak valid. Silakan coba lagi.';
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>LinkPic - Login</title>
    <link rel="icon" href="https://i.ibb.co.com/zHsYd2JG/Link-Pic-Logo.png">
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <div class="login-container">
        <div class="logo">
            <img src="https://i.ibb.co.com/zHsYd2JG/Link-Pic-Logo.png" alt="LinkPic Logo">
            <h1>LinkPic</h1>
        </div>
        <form method="POST" action="">
            <div class="form-group">
                <label for="pin">Masukkan PIN</label>
                <input type="password" id="pin" name="pin" required>
            </div>
            <?php if (isset($error)): ?>
                <div class="error"><?php echo $error; ?></div>
            <?php endif; ?>
            <button type="submit">Masuk</button>
        </form>
    </div>
</body>
</html>