<?php
// dashboard.php - Halaman Utama
session_start();

// Check if logged in
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header('Location: index.php');
    exit;
}

// Logout function
if (isset($_GET['logout'])) {
    session_destroy();
    header('Location: index.php');
    exit;
}

// Get all images from JSON
$images = [];
if (file_exists('images.json')) {
    $images = json_decode(file_get_contents('images.json'), true);
}

// Sort images by upload date (newest first)
usort($images, function($a, $b) {
    return strtotime($b['upload_date']) - strtotime($a['upload_date']);
});
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>LinkPic - Dashboard</title>
    <link rel="icon" href="https://i.ibb.co.com/zHsYd2JG/Link-Pic-Logo.png">
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <div class="dashboard-container">
        <header>
            <div class="logo">
                <img src="https://i.ibb.co.com/zHsYd2JG/Link-Pic-Logo.png" alt="LinkPic Logo">
                <h1>LinkPic</h1>
            </div>
            <div class="actions">
                <a href="?logout=1" class="logout-btn">Keluar</a>
            </div>
        </header>
        
        <div class="upload-section">
            <h2>Upload Gambar Baru</h2>
            <form action="upload.php" method="POST" enctype="multipart/form-data">
                <div class="form-group">
                    <label for="image">Pilih Gambar</label>
                    <input type="file" id="image" name="image" accept="image/*" required>
                    <div class="file-name"></div>
                </div>
                <button type="submit">Upload</button>
            </form>
        </div>
        
        <div class="images-section">
            <h2>Gambar Anda</h2>
            
            <?php if (empty($images)): ?>
                <p class="no-images">Belum ada gambar yang diupload.</p>
            <?php else: ?>
                <div class="image-grid">
                    <?php foreach ($images as $image): ?>
                        <div class="image-card">
                            <div class="image-preview">
                                <img src="<?php echo $image['path']; ?>" alt="<?php echo $image['filename']; ?>">
                            </div>
                            <div class="image-info">
                                <p class="filename"><?php echo $image['filename']; ?></p>
                                <p class="upload-date"><?php echo date('d/m/Y H:i', strtotime($image['upload_date'])); ?></p>
                                <div class="image-link">
                                    <input type="text" readonly value="<?php echo $image['url']; ?>">
                                    <button class="copy-btn" data-link="<?php echo $image['url']; ?>">Salin</button>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <script src="assets/js/script.js"></script>
</body>
</html>