<?php
session_start();
error_reporting(0);

// Konfigurasi
$config = [
    'username' => 'rizaldi',
    'password' => 'admin123',
    'json_file' => 'data.json'
];

// Fungsi untuk membaca data JSON
function readJsonData() {
    global $config;
    if (file_exists($config['json_file'])) {
        $jsonData = file_get_contents($config['json_file']);
        return json_decode($jsonData, true) ?: [];
    }
    return [];
}

// Fungsi untuk menyimpan data JSON
function saveJsonData($data) {
    global $config;
    $jsonData = json_encode($data, JSON_PRETTY_PRINT);
    file_put_contents($config['json_file'], $jsonData);
}

// Menghasilkan kode unik untuk link
function generateUniqueCode($length = 6) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $code = '';
    for ($i = 0; $i < $length; $i++) {
        $code .= $characters[rand(0, strlen($characters) - 1)];
    }
    return $code;
}

// Proses login
if (isset($_POST['login'])) {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    
    if ($username === $config['username'] && $password === $config['password']) {
        $_SESSION['loggedin'] = true;
        header('Location: ' . $_SERVER['PHP_SELF']);
        exit;
    } else {
        $loginError = "Username atau password salah!";
    }
}

// Proses logout
if (isset($_GET['logout'])) {
    session_destroy();
    header('Location: ' . $_SERVER['PHP_SELF']);
    exit;
}

// Tambah link baru
if (isset($_POST['add_link']) && $_SESSION['loggedin']) {
    $title = $_POST['title'] ?? '';
    $description = $_POST['description'] ?? '';
    
    if (!empty($title) && !empty($description)) {
        $data = readJsonData();
        $code = generateUniqueCode();
        
        // Pastikan kode unik
        while (isset($data[$code])) {
            $code = generateUniqueCode();
        }
        
        $data[$code] = [
            'title' => $title,
            'description' => $description,
            'created_at' => date('Y-m-d H:i:s')
        ];
        
        saveJsonData($data);
        $successMessage = "Link berhasil dibuat! Kode: $code";
    } else {
        $addError = "Judul dan deskripsi harus diisi!";
    }
}

// Hapus link
if (isset($_GET['delete']) && $_SESSION['loggedin']) {
    $code = $_GET['delete'];
    $data = readJsonData();
    
    if (isset($data[$code])) {
        unset($data[$code]);
        saveJsonData($data);
        $successMessage = "Link dengan kode $code berhasil dihapus!";
    }
}

// Cek jika mengakses link
if (isset($_GET['kode'])) {
    $code = $_GET['kode'];
    $data = readJsonData();
    
    // Jika kode ditemukan, tampilkan halaman link
    if (isset($data[$code])) {
        $linkData = $data[$code];
        include 'link.php';
        exit;
    } else {
        // Jika kode tidak ditemukan, tampilkan halaman 404
        include '404.php';
        exit;
    }
}

// Generate halaman link.php secara dinamis jika tidak ada
if (!file_exists('link.php')) {
    $linkTemplate = <<<EOT
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars(\$linkData['title']); ?></title>
    <style>
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        body {
            background-color: #f8f9fa;
            color: #333;
            line-height: 1.6;
            padding: 20px;
            max-width: 800px;
            margin: 0 auto;
        }
        .container {
            background-color: white;
            border-radius: 15px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
            padding: 30px;
            margin-top: 50px;
        }
        h1 {
            color: #2c3e50;
            margin-bottom: 20px;
            word-wrap: break-word;
        }
        .description {
            font-size: 18px;
            margin-bottom: 20px;
            word-wrap: break-word;
            line-height: 1.8;
        }
        .timestamp {
            color: #7f8c8d;
            font-size: 14px;
            margin-top: 20px;
        }
        @media (max-width: 768px) {
            .container {
                padding: 20px;
                margin-top: 30px;
            }
            h1 {
                font-size: 24px;
            }
            .description {
                font-size: 16px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <h1><?php echo htmlspecialchars(\$linkData['title']); ?></h1>
        <div class="description"><?php echo nl2br(htmlspecialchars(\$linkData['description'])); ?></div>
        <div class="timestamp">Dibuat pada: <?php echo htmlspecialchars(\$linkData['created_at']); ?></div>
    </div>
</body>
</html>
EOT;
    file_put_contents('link.php', $linkTemplate);
}

// Generate halaman 404.php secara dinamis jika tidak ada
if (!file_exists('404.php')) {
    $notFoundTemplate = <<<EOT
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>404 - Halaman Tidak Ditemukan</title>
    <style>
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        body {
            background-color: #f8f9fa;
            color: #333;
            line-height: 1.6;
            padding: 20px;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
            justify-content: center;
            align-items: center;
            text-align: center;
        }
        .container {
            background-color: white;
            border-radius: 15px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
            padding: 30px;
            max-width: 600px;
            width: 100%;
        }
        h1 {
            font-size: 48px;
            color: #e74c3c;
            margin-bottom: 20px;
        }
        p {
            font-size: 18px;
            margin-bottom: 20px;
        }
        .countdown {
            font-size: 22px;
            font-weight: bold;
            margin: 20px 0;
            color: #2c3e50;
        }
        @media (max-width: 768px) {
            h1 {
                font-size: 36px;
            }
            p {
                font-size: 16px;
            }
            .countdown {
                font-size: 18px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>404</h1>
        <p>Website ini telah ditutup.</p>
        <p>Website dapat dibuka kembali dalam:</p>
        <div class="countdown">10 hari lagi</div>
    </div>
</body>
</html>
EOT;
    file_put_contents('404.php', $notFoundTemplate);
}

// Jika belum ada file data.json, buat file kosong
if (!file_exists($config['json_file'])) {
    saveJsonData([]);
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Link Generator</title>
    <style>
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        body {
            background-color: #f8f9fa;
            color: #333;
            line-height: 1.6;
        }
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }
        .login-container {
            max-width: 400px;
            margin: 100px auto;
            background-color: white;
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        }
        .dashboard {
            padding: 20px 0;
        }
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 1px solid #eee;
        }
        h1, h2 {
            color: #2c3e50;
            margin-bottom: 20px;
        }
        .form-group {
            margin-bottom: 20px;
        }
        label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
        }
        input[type="text"], 
        input[type="password"],
        textarea {
            width: 100%;
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 16px;
        }
        textarea {
            height: 150px;
            resize: vertical;
        }
        button {
            background-color: #3498db;
            color: white;
            border: none;
            padding: 12px 20px;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            transition: background-color 0.3s;
        }
        button:hover {
            background-color: #2980b9;
        }
        .btn-danger {
            background-color: #e74c3c;
        }
        .btn-danger:hover {
            background-color: #c0392b;
        }
        .alert {
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 5px;
        }
        .alert-success {
            background-color: #d4edda;
            color: #155724;
        }
        .alert-danger {
            background-color: #f8d7da;
            color: #721c24;
        }
        .link-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            background-color: white;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            border-radius: 10px;
            overflow: hidden;
        }
        .link-table th, .link-table td {
            padding: 12px 15px;
            text-align: left;
            border-bottom: 1px solid #eee;
        }
        .link-table th {
            background-color: #f1f1f1;
            font-weight: 600;
        }
        .link-table tr:last-child td {
            border-bottom: none;
        }
        .link-url {
            word-break: break-all;
        }
        .action-btn {
            padding: 8px 12px;
            font-size: 14px;
        }
        .card {
            background-color: white;
            border-radius: 10px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
            padding: 25px;
            margin-bottom: 30px;
        }
        .logout-link {
            color: #e74c3c;
            text-decoration: none;
            font-weight: 600;
        }
        .logout-link:hover {
            text-decoration: underline;
        }
        @media (max-width: 768px) {
            .header {
                flex-direction: column;
                align-items: flex-start;
            }
            .header .logout-link {
                margin-top: 15px;
            }
            .link-table {
                font-size: 14px;
            }
            .link-table th, .link-table td {
                padding: 10px;
            }
            .action-btn {
                padding: 6px 10px;
                font-size: 12px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <?php if (!isset($_SESSION['loggedin'])): ?>
            <!-- Halaman Login -->
            <div class="login-container">
                <h1>Login Admin</h1>
                
                <?php if (isset($loginError)): ?>
                    <div class="alert alert-danger"><?php echo $loginError; ?></div>
                <?php endif; ?>
                
                <form method="post">
                    <div class="form-group">
                        <label for="username">Username</label>
                        <input type="text" id="username" name="username" required>
                    </div>
                    <div class="form-group">
                        <label for="password">Password</label>
                        <input type="password" id="password" name="password" required>
                    </div>
                    <button type="submit" name="login">Login</button>
                </form>
            </div>
        <?php else: ?>
            <!-- Dashboard Admin -->
            <div class="dashboard">
                <div class="header">
                    <h1>Dashboard Admin</h1>
                    <a href="?logout=1" class="logout-link">Logout</a>
                </div>
                
                <?php if (isset($successMessage)): ?>
                    <div class="alert alert-success"><?php echo $successMessage; ?></div>
                <?php endif; ?>
                
                <?php if (isset($addError)): ?>
                    <div class="alert alert-danger"><?php echo $addError; ?></div>
                <?php endif; ?>
                
                <div class="card">
                    <h2>Buat Link Baru</h2>
                    <form method="post">
                        <div class="form-group">
                            <label for="title">Judul</label>
                            <input type="text" id="title" name="title" required>
                        </div>
                        <div class="form-group">
                            <label for="description">Deskripsi (Mendukung emoji)</label>
                            <textarea id="description" name="description" required></textarea>
                        </div>
                        <button type="submit" name="add_link">Buat Link</button>
                    </form>
                </div>
                
                <div class="card">
                    <h2>Daftar Link</h2>
                    <?php
                    $data = readJsonData();
                    if (empty($data)):
                    ?>
                        <p>Belum ada link yang dibuat.</p>
                    <?php else: ?>
                        <table class="link-table">
                            <thead>
                                <tr>
                                    <th>Kode</th>
                                    <th>Judul</th>
                                    <th>URL</th>
                                    <th>Dibuat</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($data as $code => $info): ?>
                                    <tr>
                                        <td><?php echo htmlspecialchars($code); ?></td>
                                        <td><?php echo htmlspecialchars($info['title']); ?></td>
                                        <td class="link-url">
                                            <a href="?kode=<?php echo urlencode($code); ?>" target="_blank">
                                                <?php echo htmlspecialchars($_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF'] . '?kode=' . $code); ?>
                                            </a>
                                        </td>
                                        <td><?php echo htmlspecialchars($info['created_at']); ?></td>
                                        <td>
                                            <a href="?delete=<?php echo urlencode($code); ?>" onclick="return confirm('Yakin ingin menghapus link ini?')">
                                                <button class="btn-danger action-btn">Hapus</button>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>