<?php
require_once 'config.php';
require_once 'functions.php';

// Mendapatkan pengaturan aplikasi
$settings = getSettings();

// Mengatur tema
$theme = $settings['theme'];
if ($theme === 'auto') {
    $theme = isset($_SERVER['HTTP_SEC_CH_PREFERS_COLOR_SCHEME']) && 
             $_SERVER['HTTP_SEC_CH_PREFERS_COLOR_SCHEME'] === 'dark' ? 'dark' : 'light';
}

// Proses form pengaturan
$message = '';
$messageType = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action']) && $_POST['action'] === 'update_settings') {
        $newSettings = [
            'app_name' => trim($_POST['app_name']),
            'theme' => $_POST['theme'],
            'currency' => trim($_POST['currency']),
            'date_format' => trim($_POST['date_format']),
            'time_format' => trim($_POST['time_format']),
            'reminder_days' => (int)$_POST['reminder_days']
        ];
        
        $updated = updateSettings($newSettings);
        if ($updated) {
            $message = 'Pengaturan berhasil disimpan';
            $messageType = 'success';
            $settings = getSettings(); // Refresh settings
        } else {
            $message = 'Gagal menyimpan pengaturan';
            $messageType = 'error';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="id" data-theme="<?php echo $theme; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Meta tags untuk mencegah pengindeksan oleh mesin pencari -->
    <meta name="robots" content="noindex, nofollow">
    <meta name="googlebot" content="noindex, nofollow">
    <meta name="bingbot" content="noindex, nofollow">
    <meta name="yandex" content="none">
    <link rel="icon" href="https://app.dezki.biz.id/linkpic/assets/uploads/67dc5f2646a8d.png">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pengaturan - <?php echo $settings['app_name']; ?></title>
    <link rel="stylesheet" href="assets/css/style.css">
    <script src="assets/js/app.js" defer></script>
</head>
<body>
    <div class="app-container">
        <!-- Sidebar -->
        <aside class="sidebar">
            <div class="sidebar-header">
                <h1><?php echo $settings['app_name']; ?></h1>
            </div>
            <nav class="sidebar-nav">
                <ul>
                    <li><a href="index.php"><i class="icon icon-dashboard"></i> Dashboard</a></li>
                    <li><a href="businesses.php"><i class="icon icon-business"></i> Bisnis</a></li>
                    <li><a href="transactions.php"><i class="icon icon-transaction"></i> Transaksi</a></li>
                    <li><a href="reports.php"><i class="icon icon-report"></i> Laporan</a></li>
                    <li class="active"><a href="settings.php"><i class="icon icon-settings"></i> Pengaturan</a></li>
                </ul>
            </nav>
        </aside>

        <!-- Main Content -->
        <main class="main-content">
            <header class="content-header">
                <h2>Pengaturan Aplikasi</h2>
            </header>

            <?php if (!empty($message)): ?>
            <div class="alert alert-<?php echo $messageType; ?>">
                <?php echo $message; ?>
            </div>
            <?php endif; ?>

            <div class="card">
                <div class="card-body">
                    <form method="post">
                        <input type="hidden" name="action" value="update_settings">
                        
                        <div class="form-group">
                            <label for="app_name">Nama Aplikasi</label>
                            <input type="text" id="app_name" name="app_name" class="form-control" 
                                   value="<?php echo htmlspecialchars($settings['app_name']); ?>" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="theme">Tema</label>
                            <select id="theme" name="theme" class="form-control">
                                <option value="light" <?php echo $settings['theme'] === 'light' ? 'selected' : ''; ?>>Terang</option>
                                <option value="dark" <?php echo $settings['theme'] === 'dark' ? 'selected' : ''; ?>>Gelap</option>
                                <option value="auto" <?php echo $settings['theme'] === 'auto' ? 'selected' : ''; ?>>Otomatis (Ikuti Sistem)</option>
                            </select>
                        </div>
                        
                        <div class="form-group">
                            <label for="currency">Simbol Mata Uang</label>
                            <input type="text" id="currency" name="currency" class="form-control" 
                                   value="<?php echo htmlspecialchars($settings['currency']); ?>" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="date_format">Format Tanggal</label>
                            <select id="date_format" name="date_format" class="form-control">
                                <option value="d/m/Y" <?php echo $settings['date_format'] === 'd/m/Y' ? 'selected' : ''; ?>>DD/MM/YYYY (31/12/2025)</option>
                                <option value="m/d/Y" <?php echo $settings['date_format'] === 'm/d/Y' ? 'selected' : ''; ?>>MM/DD/YYYY (12/31/2025)</option>
                                <option value="Y-m-d" <?php echo $settings['date_format'] === 'Y-m-d' ? 'selected' : ''; ?>>YYYY-MM-DD (2025-12-31)</option>
                                <option value="d F Y" <?php echo $settings['date_format'] === 'd F Y' ? 'selected' : ''; ?>>DD Month YYYY (31 Desember 2025)</option>
                            </select>
                        </div>
                        
                        <div class="form-group">
                            <label for="time_format">Format Waktu</label>
                            <select id="time_format" name="time_format" class="form-control">
                                <option value="H:i" <?php echo $settings['time_format'] === 'H:i' ? 'selected' : ''; ?>>24 Jam (14:30)</option>
                                <option value="h:i A" <?php echo $settings['time_format'] === 'h:i A' ? 'selected' : ''; ?>>12 Jam (02:30 PM)</option>
                            </select>
                        </div>
                        
                        <div class="form-group">
                            <label for="reminder_days">Pengingat Jatuh Tempo (Hari)</label>
                            <input type="number" id="reminder_days" name="reminder_days" class="form-control" 
                                   value="<?php echo $settings['reminder_days']; ?>" min="1" max="30" required>
                            <small class="form-text text-muted">
                                Jumlah hari sebelum jatuh tempo untuk menampilkan pengingat
                            </small>
                        </div>
                        
                        <div class="form-actions">
                            <button type="submit" class="btn btn-primary">Simpan Pengaturan</button>
                        </div>
                    </form>
                </div>
            </div>
            
            <div class="card mt-4">
                <div class="card-header">
                    <h3>Backup Data</h3>
                </div>
                <div class="card-body">
                    <p>
                        Data aplikasi disimpan dalam format JSON di folder <code>/data</code>. 
                        Anda dapat mengunduh file-file berikut untuk backup:
                    </p>
                    
                    <ul class="backup-files">
                        <li>
                            <a href="data/businesses.json" download class="btn btn-sm btn-secondary">
                                businesses.json
                            </a>
                            - Data bisnis
                        </li>
                        <li>
                            <a href="data/personal.json" download class="btn btn-sm btn-secondary">
                                personal.json
                            </a>
                            - Data keuangan pribadi
                        </li>
                        <li>
                            <a href="data/transactions.json" download class="btn btn-sm btn-secondary">
                                transactions.json
                            </a>
                            - Data transaksi utang piutang
                        </li>
                        <li>
                            <a href="data/settings.json" download class="btn btn-sm btn-secondary">
                                settings.json
                            </a>
                            - Pengaturan aplikasi
                        </li>
                    </ul>
                    
                    <p class="alert alert-info mt-3">
                        <i class="icon icon-info"></i>
                        Untuk melakukan restore, cukup ganti file yang ada di folder <code>/data</code> dengan file backup Anda.
                    </p>
                </div>
            </div>
        </main>
    </div>
</body>
</html>