<?php
session_start();

// Jika sudah login, redirect ke index.php
if (isset($_SESSION['logged_in']) && $_SESSION['logged_in'] === true) {
    header('Location: index.php');
    exit;
}

$error = '';

// Proses login
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $pin = trim($_POST['pin'] ?? '');
    
    if ($pin === '051205') {
        $_SESSION['logged_in'] = true;
        header('Location: index.php');
        exit;
    } else {
        $error = 'PIN tidak valid!';
    }
}

// Mendapatkan nama aplikasi (jika file settings.json ada)
$appName = 'Aplikasi Pengelola Utang Piutang';
if (file_exists('data/settings.json')) {
    $settings = json_decode(file_get_contents('data/settings.json'), true);
    if (isset($settings['app_name'])) {
        $appName = $settings['app_name'];
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Meta tags untuk mencegah pengindeksan oleh mesin pencari -->
    <meta name="robots" content="noindex, nofollow">
    <meta name="googlebot" content="noindex, nofollow">
    <meta name="bingbot" content="noindex, nofollow">
    <meta name="yandex" content="none">
    <link rel="icon" href="https://app.dezki.biz.id/linkpic/assets/uploads/67dc5f2646a8d.png">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="robots" content="noindex, nofollow">
    <title>Login - <?php echo htmlspecialchars($appName); ?></title>
    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        .login-container {
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            background-color: var(--bg-light);
        }
        .login-card {
            background-color: var(--card-bg);
            border-radius: 8px;
            box-shadow: 0 4px 15px var(--shadow-color);
            width: 100%;
            max-width: 400px;
            padding: 30px;
        }
        .login-header {
            text-align: center;
            margin-bottom: 30px;
        }
        .login-header h1 {
            color: var(--primary-color);
            font-size: 1.5rem;
            margin-bottom: 5px;
        }
        .login-form .form-group {
            margin-bottom: 20px;
        }
        .pin-input {
            letter-spacing: 5px;
            font-size: 1.2rem;
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-card">
            <div class="login-header">
                <h1><?php echo htmlspecialchars($appName); ?></h1>
                <p>Masukkan PIN untuk melanjutkan</p>
            </div>
            
            <?php if (!empty($error)): ?>
            <div class="alert alert-error">
                <?php echo $error; ?>
            </div>
            <?php endif; ?>
            
            <form method="post" class="login-form">
                <div class="form-group">
                    <label for="pin">PIN</label>
                    <input type="password" id="pin" name="pin" class="form-control pin-input" maxlength="6" pattern="[0-9]*" inputmode="numeric" autocomplete="off" autofocus required>
                </div>
                
                <div class="form-actions">
                    <button type="submit" class="btn btn-primary" style="width: 100%;">Masuk</button>
                </div>
            </form>
        </div>
    </div>
</body>
</html>