<?php
// Periksa status login
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header('Location: login.php');
    exit;
}

require_once 'config.php';
require_once 'functions.php';

// Mendapatkan pengaturan aplikasi
$settings = getSettings();

// Mendapatkan summary keuangan
$summary = getFinancialSummary();

// Mendapatkan transaksi yang akan jatuh tempo
$dueTransactions = getDueTransactions();

// Mendapatkan transaksi terbaru (5 transaksi terakhir)
$allTransactions = getAllTransactions();
usort($allTransactions, function($a, $b) {
    return strtotime($b['date']) - strtotime($a['date']);
});
$recentTransactions = array_slice($allTransactions, 0, 5);

// Mendapatkan tema
$theme = $settings['theme'];
if ($theme === 'auto') {
    // Deteksi tema dari preferensi browser
    $theme = isset($_SERVER['HTTP_SEC_CH_PREFERS_COLOR_SCHEME']) && 
             $_SERVER['HTTP_SEC_CH_PREFERS_COLOR_SCHEME'] === 'dark' ? 'dark' : 'light';
}
?>
<!DOCTYPE html>
<html lang="id" data-theme="<?php echo $theme; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Meta tags untuk mencegah pengindeksan oleh mesin pencari -->
    <meta name="robots" content="noindex, nofollow">
    <meta name="googlebot" content="noindex, nofollow">
    <meta name="bingbot" content="noindex, nofollow">
    <meta name="yandex" content="none">
    <meta name="msvalidate.01" content="noindex">
    <title><?php echo $settings['app_name']; ?></title>
    <link rel="icon" href="https://app.dezki.biz.id/linkpic/assets/uploads/67dc5f2646a8d.png">
    <link rel="stylesheet" href="assets/css/style.css">
    <script src="assets/js/app.js" defer></script>
</head>
<body>
    <div class="app-container">
        <!-- Sidebar -->
        <aside class="sidebar">
            <div class="sidebar-header">
                <h1><?php echo $settings['app_name']; ?></h1>
            </div>
            <nav class="sidebar-nav">
                <ul>
                    <li class="active"><a href="index.php"><i class="icon icon-dashboard"></i> Dashboard</a></li>
                    <li><a href="businesses.php"><i class="icon icon-business"></i> Bisnis</a></li>
                    <li><a href="transactions.php"><i class="icon icon-transaction"></i> Transaksi</a></li>
                    <li><a href="reports.php"><i class="icon icon-report"></i> Laporan</a></li>
                    <li><a href="settings.php"><i class="icon icon-settings"></i> Pengaturan</a></li>
                    <li><a href="logout.php" class="logout-link"><i class="icon icon-logout"></i> Keluar</a></li>
                </ul>
            </nav>
        </aside>

        <!-- Main Content -->
        <main class="main-content">
            <header class="content-header">
                <h2>Dashboard</h2>
                <div class="header-actions">
                    <a href="transactions.php?action=add" class="btn btn-primary">
                        <i class="icon icon-plus"></i> Transaksi Baru
                    </a>
                </div>
            </header>

            <div class="dashboard-summary">
                <div class="summary-card">
                    <h3>Keuangan Pribadi</h3>
                    <div class="summary-amount"><?php echo formatCurrency($summary['personal']['balance']); ?></div>
                    <div class="summary-details">
                        <div class="detail-item">
                            <span class="detail-label">Total Utang:</span>
                            <span class="detail-value"><?php echo formatCurrency($summary['personal']['total_debt']); ?></span>
                        </div>
                        <div class="detail-item">
                            <span class="detail-label">Total Piutang:</span>
                            <span class="detail-value"><?php echo formatCurrency($summary['personal']['total_receivable']); ?></span>
                        </div>
                    </div>
                </div>

                <?php foreach ($summary['businesses'] as $business): ?>
                <div class="summary-card">
                    <h3><?php echo htmlspecialchars($business['name']); ?></h3>
                    <div class="summary-amount"><?php echo formatCurrency($business['balance']); ?></div>
                    <div class="summary-details">
                        <div class="detail-item">
                            <span class="detail-label">Total Utang:</span>
                            <span class="detail-value"><?php echo formatCurrency($business['total_debt']); ?></span>
                        </div>
                        <div class="detail-item">
                            <span class="detail-label">Total Piutang:</span>
                            <span class="detail-value"><?php echo formatCurrency($business['total_receivable']); ?></span>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>

            <div class="dashboard-sections">
                <!-- Transaksi yang akan jatuh tempo -->
                <section class="dashboard-section">
                    <h3>Jatuh Tempo Dalam <?php echo $settings['reminder_days']; ?> Hari</h3>
                    <?php if (empty($dueTransactions)): ?>
                    <div class="empty-state">
                        <p>Tidak ada transaksi yang akan jatuh tempo dalam waktu dekat.</p>
                    </div>
                    <?php else: ?>
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Deskripsi</th>
                                    <th>Jumlah</th>
                                    <th>Jatuh Tempo</th>
                                    <th>Tipe</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($dueTransactions as $transaction): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($transaction['description']); ?></td>
                                    <td><?php echo formatCurrency($transaction['amount']); ?></td>
                                    <td><?php echo formatDate($transaction['due_date']); ?></td>
                                    <td>
                                        <?php if ($transaction['type'] === 'debt'): ?>
                                        <span class="badge badge-danger">Utang</span>
                                        <?php else: ?>
                                        <span class="badge badge-success">Piutang</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <a href="transactions.php?action=view&id=<?php echo $transaction['id']; ?>" class="btn btn-sm btn-info">
                                            Detail
                                        </a>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php endif; ?>
                </section>

                <!-- Transaksi Terbaru -->
                <section class="dashboard-section">
                    <h3>Transaksi Terbaru</h3>
                    <?php if (empty($recentTransactions)): ?>
                    <div class="empty-state">
                        <p>Belum ada transaksi yang tercatat.</p>
                    </div>
                    <?php else: ?>
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Tanggal</th>
                                    <th>Deskripsi</th>
                                    <th>Jumlah</th>
                                    <th>Tipe</th>
                                    <th>Status</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($recentTransactions as $transaction): ?>
                                <tr>
                                    <td><?php echo formatDate($transaction['date']); ?></td>
                                    <td><?php echo htmlspecialchars($transaction['description']); ?></td>
                                    <td><?php echo formatCurrency($transaction['amount']); ?></td>
                                    <td>
                                        <?php if ($transaction['type'] === 'debt'): ?>
                                        <span class="badge badge-danger">Utang</span>
                                        <?php else: ?>
                                        <span class="badge badge-success">Piutang</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if ($transaction['status'] === 'active'): ?>
                                        <span class="badge badge-warning">Aktif</span>
                                        <?php elseif ($transaction['status'] === 'paid'): ?>
                                        <span class="badge badge-success">Lunas</span>
                                        <?php else: ?>
                                        <span class="badge badge-secondary">Dibatalkan</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <a href="transactions.php?action=view&id=<?php echo $transaction['id']; ?>" class="btn btn-sm btn-info">
                                            Detail
                                        </a>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php endif; ?>
                </section>
            </div>
        </main>
    </div>
</body>
</html>