<?php
require_once 'config.php';
require_once 'functions.php';

// Mendapatkan pengaturan aplikasi
$settings = getSettings();

// Mengatur tema
$theme = $settings['theme'];
if ($theme === 'auto') {
    $theme = isset($_SERVER['HTTP_SEC_CH_PREFERS_COLOR_SCHEME']) && 
             $_SERVER['HTTP_SEC_CH_PREFERS_COLOR_SCHEME'] === 'dark' ? 'dark' : 'light';
}

// Proses form
$message = '';
$messageType = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Tambah bisnis baru
    if (isset($_POST['action']) && $_POST['action'] === 'add') {
        $name = trim($_POST['name']);
        $description = trim($_POST['description']);
        $initialBalance = (float)$_POST['initial_balance'];
        
        if (empty($name)) {
            $message = 'Nama bisnis tidak boleh kosong';
            $messageType = 'error';
        } else {
            $newBusiness = addBusiness($name, $description, $initialBalance);
            if ($newBusiness) {
                $message = 'Bisnis berhasil ditambahkan';
                $messageType = 'success';
            } else {
                $message = 'Gagal menambahkan bisnis';
                $messageType = 'error';
            }
        }
    }
    // Edit bisnis
    else if (isset($_POST['action']) && $_POST['action'] === 'edit') {
        $id = $_POST['id'];
        $name = trim($_POST['name']);
        $description = trim($_POST['description']);
        
        if (empty($name)) {
            $message = 'Nama bisnis tidak boleh kosong';
            $messageType = 'error';
        } else {
            $updated = updateBusiness($id, [
                'name' => $name,
                'description' => $description
            ]);
            
            if ($updated) {
                $message = 'Bisnis berhasil diperbarui';
                $messageType = 'success';
            } else {
                $message = 'Gagal memperbarui bisnis';
                $messageType = 'error';
            }
        }
    }
    // Hapus bisnis
    else if (isset($_POST['action']) && $_POST['action'] === 'delete') {
        $id = $_POST['id'];
        $deleted = deleteBusiness($id);
        
        if ($deleted) {
            $message = 'Bisnis berhasil dihapus';
            $messageType = 'success';
        } else {
            $message = 'Gagal menghapus bisnis';
            $messageType = 'error';
        }
    }
}

// Mendapatkan semua bisnis
$businesses = getAllBusinesses();

// Menentukan mode tampilan
$action = isset($_GET['action']) ? $_GET['action'] : 'list';
$businessId = isset($_GET['id']) ? $_GET['id'] : null;
$business = $businessId ? getBusinessById($businessId) : null;
?>
<!DOCTYPE html>
<html lang="id" data-theme="<?php echo $theme; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Meta tags untuk mencegah pengindeksan oleh mesin pencari -->
    <meta name="robots" content="noindex, nofollow">
    <meta name="googlebot" content="noindex, nofollow">
    <meta name="bingbot" content="noindex, nofollow">
    <meta name="yandex" content="none">
    <link rel="icon" href="https://app.dezki.biz.id/linkpic/assets/uploads/67dc5f2646a8d.png">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pengelolaan Bisnis - <?php echo $settings['app_name']; ?></title>
    <link rel="stylesheet" href="assets/css/style.css">
    <script src="assets/js/app.js" defer></script>
</head>
<body>
    <div class="app-container">
        <!-- Sidebar -->
        <aside class="sidebar">
            <div class="sidebar-header">
                <h1><?php echo $settings['app_name']; ?></h1>
            </div>
            <nav class="sidebar-nav">
                <ul>
                    <li><a href="index.php"><i class="icon icon-dashboard"></i> Dashboard</a></li>
                    <li class="active"><a href="businesses.php"><i class="icon icon-business"></i> Bisnis</a></li>
                    <li><a href="transactions.php"><i class="icon icon-transaction"></i> Transaksi</a></li>
                    <li><a href="reports.php"><i class="icon icon-report"></i> Laporan</a></li>
                    <li><a href="settings.php"><i class="icon icon-settings"></i> Pengaturan</a></li>
                </ul>
            </nav>
        </aside>

        <!-- Main Content -->
        <main class="main-content">
            <header class="content-header">
                <h2>Pengelolaan Bisnis</h2>
                <div class="header-actions">
                    <?php if ($action === 'list'): ?>
                    <a href="businesses.php?action=add" class="btn btn-primary">
                        <i class="icon icon-plus"></i> Tambah Bisnis Baru
                    </a>
                    <?php else: ?>
                    <a href="businesses.php" class="btn btn-secondary">
                        <i class="icon icon-back"></i> Kembali ke Daftar
                    </a>
                    <?php endif; ?>
                </div>
            </header>

            <?php if (!empty($message)): ?>
            <div class="alert alert-<?php echo $messageType; ?>">
                <?php echo $message; ?>
            </div>
            <?php endif; ?>

            <?php if ($action === 'list'): ?>
            <!-- Daftar Bisnis -->
            <div class="card">
                <div class="card-body">
                    <?php if (empty($businesses)): ?>
                    <div class="empty-state">
                        <p>Belum ada bisnis yang terdaftar.</p>
                        <a href="businesses.php?action=add" class="btn btn-primary">
                            Tambah Bisnis Baru
                        </a>
                    </div>
                    <?php else: ?>
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Nama</th>
                                    <th>Deskripsi</th>
                                    <th>Saldo</th>
                                    <th>Total Utang</th>
                                    <th>Total Piutang</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($businesses as $b): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($b['name']); ?></td>
                                    <td><?php echo htmlspecialchars($b['description']); ?></td>
                                    <td><?php echo formatCurrency($b['balance']); ?></td>
                                    <td><?php echo formatCurrency(getTotalDebtByEntity('business', $b['id'])); ?></td>
                                    <td><?php echo formatCurrency(getTotalReceivableByEntity('business', $b['id'])); ?></td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="businesses.php?action=edit&id=<?php echo $b['id']; ?>" class="btn btn-sm btn-info">
                                                Edit
                                            </a>
                                            <a href="transactions.php?filter_entity=business&filter_entity_id=<?php echo $b['id']; ?>" class="btn btn-sm btn-secondary">
                                                Transaksi
                                            </a>
                                            <button type="button" class="btn btn-sm btn-danger" 
                                                    onclick="confirmDelete('<?php echo $b['id']; ?>', '<?php echo htmlspecialchars($b['name']); ?>')">
                                                Hapus
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Form hapus (hidden) -->
            <form id="deleteForm" method="post" style="display: none;">
                <input type="hidden" name="action" value="delete">
                <input type="hidden" name="id" id="deleteId">
            </form>

            <script>
                function confirmDelete(id, name) {
                    if (confirm('Apakah Anda yakin ingin menghapus bisnis "' + name + '"?')) {
                        document.getElementById('deleteId').value = id;
                        document.getElementById('deleteForm').submit();
                    }
                }
            </script>
            
            <?php elseif ($action === 'add'): ?>
            <!-- Form Tambah Bisnis -->
            <div class="card">
                <div class="card-header">
                    <h3>Tambah Bisnis Baru</h3>
                </div>
                <div class="card-body">
                    <form method="post">
                        <input type="hidden" name="action" value="add">
                        
                        <div class="form-group">
                            <label for="name">Nama Bisnis</label>
                            <input type="text" id="name" name="name" class="form-control" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="description">Deskripsi</label>
                            <textarea id="description" name="description" class="form-control" rows="3"></textarea>
                        </div>
                        
                        <div class="form-group">
                            <label for="initial_balance">Saldo Awal</label>
                            <input type="number" id="initial_balance" name="initial_balance" class="form-control" value="0" min="0">
                        </div>
                        
                        <div class="form-actions">
                            <button type="submit" class="btn btn-primary">Simpan</button>
                            <a href="businesses.php" class="btn btn-secondary">Batal</a>
                        </div>
                    </form>
                </div>
            </div>
            
            <?php elseif ($action === 'edit' && $business): ?>
            <!-- Form Edit Bisnis -->
            <div class="card">
                <div class="card-header">
                    <h3>Edit Bisnis</h3>
                </div>
                <div class="card-body">
                    <form method="post">
                        <input type="hidden" name="action" value="edit">
                        <input type="hidden" name="id" value="<?php echo $business['id']; ?>">
                        
                        <div class="form-group">
                            <label for="name">Nama Bisnis</label>
                            <input type="text" id="name" name="name" class="form-control" 
                                   value="<?php echo htmlspecialchars($business['name']); ?>" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="description">Deskripsi</label>
                            <textarea id="description" name="description" class="form-control" 
                                      rows="3"><?php echo htmlspecialchars($business['description']); ?></textarea>
                        </div>
                        
                        <div class="form-group">
                            <label for="balance">Saldo Saat Ini</label>
                            <input type="text" id="balance" class="form-control" 
                                   value="<?php echo formatCurrency($business['balance']); ?>" readonly>
                            <small class="form-text text-muted">Saldo diperbarui otomatis melalui transaksi</small>
                        </div>
                        
                        <div class="form-actions">
                            <button type="submit" class="btn btn-primary">Perbarui</button>
                            <a href="businesses.php" class="btn btn-secondary">Batal</a>
                        </div>
                    </form>
                </div>
            </div>
            <?php endif; ?>
        </main>
    </div>
</body>
</html>