<?php
// Fungsi untuk membaca data dari file JSON
function readJsonFile($filename) {
    $jsonData = file_get_contents($filename);
    return json_decode($jsonData, true);
}

// Membaca data dari file JSON
$anggotaData = readJsonFile('data/anggota.json');
$pelanggaranData = readJsonFile('data/pelanggaran.json');
$peraturanData = readJsonFile('data/peraturan.json');
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pengelola Pelanggaran Ambalan Joko Tole Putri Koening</title>
    <link rel="stylesheet" href="css/style.css">
    <!-- Font Awesome untuk ikon -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body>
    <header>
        <div class="container">
            <div class="header-content">
                <div class="logo-container">
                    <img src="img/logo.png" alt="Logo Ambalan Joko Tole Putri Koening">
                    <div class="site-title">Pengelola Pelanggaran Ambalan Joko Tole Putri Koening</div>
                </div>
                <nav class="desktop-nav">
                    <ul>
                        <li><a href="#" onclick="openTab(event, 'Anggota')">Anggota</a></li>
                        <li><a href="#" onclick="openTab(event, 'Pelanggaran')">Pelanggaran</a></li>
                        <li><a href="#" onclick="openTab(event, 'Peraturan')">Peraturan</a></li>
                        <li><a href="admin.php">Login Admin</a></li>
                    </ul>
                </nav>
            </div>
        </div>
    </header>

    <main>
        <div class="container">
            <!-- Tab Anggota -->
            <div id="Anggota" class="tab-content">
                <div class="card">
                    <div class="card-header">
                        Daftar Anggota Ambalan Joko Tole Putri Koening
                    </div>
                    <div class="card-body">
                        <div class="table-container">
                            <table>
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Nama</th>
                                        <th>Nomor Induk</th>
                                        <th>Jabatan</th>
                                        <th>Angkatan</th>
                                        <th>Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $no = 1;
                                    foreach ($anggotaData['anggota'] as $anggota) {
                                        echo "<tr>";
                                        echo "<td>" . $no++ . "</td>";
                                        echo "<td>" . $anggota['nama'] . "</td>";
                                        echo "<td>" . $anggota['nomor_induk'] . "</td>";
                                        echo "<td>" . $anggota['jabatan'] . "</td>";
                                        echo "<td>" . $anggota['angkatan'] . "</td>";
                                        echo "<td>
                                            <button class='btn btn-info' onclick='showAnggotaDetail(" . $anggota['id'] . ")'>
                                                <i class='fas fa-eye'></i> Detail
                                            </button>
                                            <a href='https://wa.me/" . $anggota['nomor_wa'] . "' class='btn btn-success' target='_blank'>
                                                <i class='fab fa-whatsapp'></i> Hubungi
                                            </a>
                                        </td>";
                                        echo "</tr>";
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Tab Pelanggaran -->
            <div id="Pelanggaran" class="tab-content" style="display: none;">
                <div class="card">
                    <div class="card-header">
                        Daftar Pelanggaran Anggota
                    </div>
                    <div class="card-body">
                        <div class="table-container">
                            <table>
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Tanggal</th>
                                        <th>Nama Anggota</th>
                                        <th>Jenis Pelanggaran</th>
                                        <th>Sanksi</th>
                                        <th>Catatan</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $no = 1;
                                    foreach ($pelanggaranData['pelanggaran'] as $pelanggaran) {
                                        // Cari nama anggota berdasarkan id_anggota
                                        $namaAnggota = "";
                                        foreach ($anggotaData['anggota'] as $anggota) {
                                            if ($anggota['id'] == $pelanggaran['id_anggota']) {
                                                $namaAnggota = $anggota['nama'];
                                                break;
                                            }
                                        }
                                        
                                        echo "<tr>";
                                        echo "<td>" . $no++ . "</td>";
                                        echo "<td>" . $pelanggaran['tanggal'] . "</td>";
                                        echo "<td>" . $namaAnggota . "</td>";
                                        echo "<td>" . $pelanggaran['jenis_pelanggaran'] . "</td>";
                                        echo "<td>" . $pelanggaran['sanksi'] . "</td>";
                                        echo "<td>" . $pelanggaran['catatan'] . "</td>";
                                        echo "</tr>";
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Tab Peraturan -->
            <div id="Peraturan" class="tab-content" style="display: none;">
                <div class="card">
                    <div class="card-header">
                        Peraturan Ambalan Joko Tole Putri Koening
                    </div>
                    <div class="card-body">
                        <?php
                        foreach ($peraturanData['peraturan'] as $peraturan) {
                            echo "<div class='peraturan-section'>";
                            echo "<h3>" . $peraturan['bab'] . ": " . $peraturan['judul'] . "</h3>";
                            
                            foreach ($peraturan['isi'] as $isi) {
                                echo "<div class='peraturan-item'>";
                                echo "<h4>" . $isi['nomor'] . ". " . $isi['judul'] . "</h4>";
                                echo "<p>" . $isi['deskripsi'] . "</p>";
                                echo "</div>";
                            }
                            
                            echo "</div>";
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <!-- Modal Detail Anggota -->
    <div id="anggotaDetailModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <span class="close" onclick="closeModal()">&times;</span>
                <h2>Detail Anggota</h2>
            </div>
            <div class="modal-body">
                <div class="detail-item">
                    <span class="detail-label">Nama:</span>
                    <span id="detailNama"></span>
                </div>
                <div class="detail-item">
                    <span class="detail-label">Nomor Induk:</span>
                    <span id="detailNomorInduk"></span>
                </div>
                <div class="detail-item">
                    <span class="detail-label">Jabatan:</span>
                    <span id="detailJabatan"></span>
                </div>
                <div class="detail-item">
                    <span class="detail-label">Angkatan:</span>
                    <span id="detailAngkatan"></span>
                </div>
                <div class="detail-item">
                    <span class="detail-label">Alamat:</span>
                    <span id="detailAlamat"></span>
                </div>
                <div class="detail-item">
                    <span class="detail-label">Nomor WA:</span>
                    <span id="detailNomorWA"></span>
                </div>
                <div class="detail-item">
                    <span class="detail-label">Tanggal Lahir:</span>
                    <span id="detailTanggalLahir"></span>
                </div>
                <div class="detail-item">
                    <span class="detail-label">Email:</span>
                    <span id="detailEmail"></span>
                </div>
            </div>
            <div class="modal-footer">
                <a id="waButton" href="#" class="btn btn-success" target="_blank">
                    <i class="fab fa-whatsapp"></i> Hubungi via WhatsApp
                </a>
                <button class="btn btn-primary" onclick="closeModal()">Tutup</button>
            </div>
        </div>
    </div>

    <!-- Navigasi Mobile -->
    <nav class="mobile-nav">
        <ul>
            <li>
                <a href="#" onclick="openTab(event, 'Anggota')">
                    <i class="fas fa-users"></i>
                    <span>Anggota</span>
                </a>
            </li>
            <li>
                <a href="#" onclick="openTab(event, 'Pelanggaran')">
                    <i class="fas fa-exclamation-triangle"></i>
                    <span>Pelanggaran</span>
                </a>
            </li>
            <li>
                <a href="#" onclick="openTab(event, 'Peraturan')">
                    <i class="fas fa-book"></i>
                    <span>Peraturan</span>
                </a>
            </li>
            <li>
                <a href="admin.php">
                    <i class="fas fa-user-shield"></i>
                    <span>Admin</span>
                </a>
            </li>
        </ul>
    </nav>

    <footer>
        <div class="container">
            <p>&copy; <?php echo date('Y'); ?> Ambalan Joko Tole Putri Koening - SMK Negeri 1 Kraksaan</p>
        </div>
    </footer>

    <script src="js/script.js"></script>
</body>
</html>
