<?php
session_start();

// Fungsi untuk membaca data dari file JSON
function readJsonFile($filename) {
    $jsonData = file_get_contents($filename);
    return json_decode($jsonData, true);
}

// Fungsi untuk menulis data ke file JSON
function writeJsonFile($filename, $data) {
    $jsonData = json_encode($data, JSON_PRETTY_PRINT);
    file_put_contents($filename, $jsonData);
}

// Cek apakah user sudah login
$isLoggedIn = isset($_SESSION['user_id']);
$loginError = '';

// Proses login
if (isset($_POST['login'])) {
    $username = $_POST['username'];
    $password = $_POST['password'];
    
    $adminData = readJsonFile('data/admin.json');
    
    foreach ($adminData['admin'] as $admin) {
        if ($admin['username'] === $username && $admin['password'] === $password) {
            $_SESSION['user_id'] = $admin['id'];
            $_SESSION['username'] = $admin['username'];
            $_SESSION['nama'] = $admin['nama'];
            $_SESSION['role'] = $admin['role'];
            $isLoggedIn = true;
            break;
        }
    }
    
    if (!$isLoggedIn) {
        $loginError = 'Username atau password salah!';
    }
}

// Proses logout
if (isset($_GET['logout'])) {
    session_destroy();
    header('Location: admin.php');
    exit;
}

// Membaca data dari file JSON
$anggotaData = readJsonFile('data/anggota.json');
$pelanggaranData = readJsonFile('data/pelanggaran.json');

// Proses tambah anggota
if (isset($_POST['tambah_anggota'])) {
    $newId = 1;
    if (!empty($anggotaData['anggota'])) {
        $lastId = max(array_column($anggotaData['anggota'], 'id'));
        $newId = $lastId + 1;
    }
    
    $newAnggota = [
        'id' => $newId,
        'nama' => $_POST['nama'],
        'nomor_induk' => $_POST['nomor_induk'],
        'jabatan' => $_POST['jabatan'],
        'angkatan' => (int)$_POST['angkatan'],
        'alamat' => $_POST['alamat'],
        'nomor_wa' => $_POST['nomor_wa'],
        'tanggal_lahir' => $_POST['tanggal_lahir'],
        'email' => $_POST['email']
    ];
    
    $anggotaData['anggota'][] = $newAnggota;
    writeJsonFile('data/anggota.json', $anggotaData);
    
    header('Location: admin.php?tab=anggota');
    exit;
}

// Proses edit anggota
if (isset($_POST['edit_anggota'])) {
    $id = (int)$_POST['id'];
    
    foreach ($anggotaData['anggota'] as $key => $anggota) {
        if ($anggota['id'] === $id) {
            $anggotaData['anggota'][$key] = [
                'id' => $id,
                'nama' => $_POST['nama'],
                'nomor_induk' => $_POST['nomor_induk'],
                'jabatan' => $_POST['jabatan'],
                'angkatan' => (int)$_POST['angkatan'],
                'alamat' => $_POST['alamat'],
                'nomor_wa' => $_POST['nomor_wa'],
                'tanggal_lahir' => $_POST['tanggal_lahir'],
                'email' => $_POST['email']
            ];
            break;
        }
    }
    
    writeJsonFile('data/anggota.json', $anggotaData);
    
    header('Location: admin.php?tab=anggota');
    exit;
}

// Proses hapus anggota
if (isset($_GET['hapus_anggota'])) {
    $id = (int)$_GET['hapus_anggota'];
    
    foreach ($anggotaData['anggota'] as $key => $anggota) {
        if ($anggota['id'] === $id) {
            unset($anggotaData['anggota'][$key]);
            break;
        }
    }
    
    // Reindex array
    $anggotaData['anggota'] = array_values($anggotaData['anggota']);
    
    writeJsonFile('data/anggota.json', $anggotaData);
    
    // Hapus juga pelanggaran terkait anggota tersebut
    foreach ($pelanggaranData['pelanggaran'] as $key => $pelanggaran) {
        if ($pelanggaran['id_anggota'] === $id) {
            unset($pelanggaranData['pelanggaran'][$key]);
        }
    }
    
    // Reindex array
    $pelanggaranData['pelanggaran'] = array_values($pelanggaranData['pelanggaran']);
    
    writeJsonFile('data/pelanggaran.json', $pelanggaranData);
    
    header('Location: admin.php?tab=anggota');
    exit;
}

// Proses tambah pelanggaran
if (isset($_POST['tambah_pelanggaran'])) {
    $newId = 1;
    if (!empty($pelanggaranData['pelanggaran'])) {
        $lastId = max(array_column($pelanggaranData['pelanggaran'], 'id'));
        $newId = $lastId + 1;
    }
    
    $newPelanggaran = [
        'id' => $newId,
        'id_anggota' => (int)$_POST['id_anggota'],
        'tanggal' => $_POST['tanggal'],
        'jenis_pelanggaran' => $_POST['jenis_pelanggaran'],
        'deskripsi' => $_POST['deskripsi'],
        'sanksi' => $_POST['sanksi'],
        'catatan' => $_POST['catatan']
    ];
    
    $pelanggaranData['pelanggaran'][] = $newPelanggaran;
    writeJsonFile('data/pelanggaran.json', $pelanggaranData);
    
    header('Location: admin.php?tab=pelanggaran');
    exit;
}

// Proses edit pelanggaran
if (isset($_POST['edit_pelanggaran'])) {
    $id = (int)$_POST['id'];
    
    foreach ($pelanggaranData['pelanggaran'] as $key => $pelanggaran) {
        if ($pelanggaran['id'] === $id) {
            $pelanggaranData['pelanggaran'][$key] = [
                'id' => $id,
                'id_anggota' => (int)$_POST['id_anggota'],
                'tanggal' => $_POST['tanggal'],
                'jenis_pelanggaran' => $_POST['jenis_pelanggaran'],
                'deskripsi' => $_POST['deskripsi'],
                'sanksi' => $_POST['sanksi'],
                'catatan' => $_POST['catatan']
            ];
            break;
        }
    }
    
    writeJsonFile('data/pelanggaran.json', $pelanggaranData);
    
    header('Location: admin.php?tab=pelanggaran');
    exit;
}

// Proses hapus pelanggaran
if (isset($_GET['hapus_pelanggaran'])) {
    $id = (int)$_GET['hapus_pelanggaran'];
    
    foreach ($pelanggaranData['pelanggaran'] as $key => $pelanggaran) {
        if ($pelanggaran['id'] === $id) {
            unset($pelanggaranData['pelanggaran'][$key]);
            break;
        }
    }
    
    // Reindex array
    $pelanggaranData['pelanggaran'] = array_values($pelanggaranData['pelanggaran']);
    
    writeJsonFile('data/pelanggaran.json', $pelanggaranData);
    
    header('Location: admin.php?tab=pelanggaran');
    exit;
}

// Menentukan tab aktif
$activeTab = isset($_GET['tab']) ? $_GET['tab'] : 'anggota';
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin - Pengelola Pelanggaran Ambalan Joko Tole Putri Koening</title>
    <link rel="stylesheet" href="css/style.css">
    <!-- Font Awesome untuk ikon -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        .login-container {
            max-width: 400px;
            margin: 50px auto;
            padding: 20px;
            background-color: white;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }
        
        .form-group {
            margin-bottom: 15px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 5px;
            font-weight: 500;
        }
        
        .form-group input, .form-group select, .form-group textarea {
            width: 100%;
            padding: 8px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 1rem;
        }
        
        .form-group textarea {
            height: 100px;
        }
        
        .error-message {
            color: #dc3545;
            margin-bottom: 15px;
        }
        
        .tab-nav {
            display: flex;
            border-bottom: 1px solid #ddd;
            margin-bottom: 20px;
        }
        
        .tab-link {
            padding: 10px 15px;
            cursor: pointer;
            border: 1px solid transparent;
            border-bottom: none;
            margin-bottom: -1px;
            background-color: #f8f9fa;
        }
        
        .tab-link.active {
            background-color: white;
            border-color: #ddd;
            border-bottom-color: white;
        }
        
        .action-buttons {
            display: flex;
            gap: 5px;
        }
        
        @media (max-width: 768px) {
            .action-buttons {
                flex-direction: column;
            }
            
            .action-buttons .btn {
                margin-bottom: 5px;
            }
        }
    </style>
</head>
<body>
    <header>
        <div class="container">
            <div class="header-content">
                <div class="logo-container">
                    <img src="img/logo.png" alt="Logo Ambalan Joko Tole Putri Koening">
                    <div class="site-title">Admin - Pengelola Pelanggaran Ambalan Joko Tole Putri Koening</div>
                </div>
                <?php if ($isLoggedIn): ?>
                <nav class="desktop-nav">
                    <ul>
                        <li><a href="index.php">Kembali ke Beranda</a></li>
                        <li><a href="admin.php?logout=1">Logout</a></li>
                    </ul>
                </nav>
                <?php endif; ?>
            </div>
        </div>
    </header>

    <main>
        <div class="container">
            <?php if (!$isLoggedIn): ?>
                <!-- Form Login -->
                <div class="login-container">
                    <h2>Login Admin</h2>
                    <?php if ($loginError): ?>
                        <div class="error-message"><?php echo $loginError; ?></div>
                    <?php endif; ?>
                    <form method="post" action="">
                        <div class="form-group">
                            <label for="username">Username</label>
                            <input type="text" id="username" name="username" required>
                        </div>
                        <div class="form-group">
                            <label for="password">Password</label>
                            <input type="password" id="password" name="password" required>
                        </div>
                        <button type="submit" name="login" class="btn btn-primary">Login</button>
                    </form>
                </div>
            <?php else: ?>
                <!-- Panel Admin -->
                <div class="tab-nav">
                    <a href="admin.php?tab=anggota" class="tab-link <?php echo $activeTab === 'anggota' ? 'active' : ''; ?>">
                        <i class="fas fa-users"></i> Kelola Anggota
                    </a>
                    <a href="admin.php?tab=pelanggaran" class="tab-link <?php echo $activeTab === 'pelanggaran' ? 'active' : ''; ?>">
                        <i class="fas fa-exclamation-triangle"></i> Kelola Pelanggaran
                    </a>
                </div>
                
                <?php if ($activeTab === 'anggota'): ?>
                    <!-- Kelola Anggota -->
                    <div class="card">
                        <div class="card-header">
                            <div style="display: flex; justify-content: space-between; align-items: center;">
                                <span>Daftar Anggota</span>
                                <button class="btn btn-primary" onclick="showTambahAnggotaForm()">
                                    <i class="fas fa-plus"></i> Tambah Anggota
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-container">
                                <table>
                                    <thead>
                                        <tr>
                                            <th>No</th>
                                            <th>Nama</th>
                                            <th>Nomor Induk</th>
                                            <th>Jabatan</th>
                                            <th>Angkatan</th>
                                            <th>Aksi</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $no = 1;
                                        foreach ($anggotaData['anggota'] as $anggota) {
                                            echo "<tr>";
                                            echo "<td>" . $no++ . "</td>";
                                            echo "<td>" . $anggota['nama'] . "</td>";
                                            echo "<td>" . $anggota['nomor_induk'] . "</td>";
                                            echo "<td>" . $anggota['jabatan'] . "</td>";
                                            echo "<td>" . $anggota['angkatan'] . "</td>";
                                            echo "<td class='action-buttons'>
                                                <button class='btn btn-info' onclick='showDetailAnggota(" . json_encode($anggota) . ")'>
                                                    <i class='fas fa-eye'></i> Detail
                                                </button>
                                                <button class='btn btn-primary' onclick='showEditAnggotaForm(" . json_encode($anggota) . ")'>
                                                    <i class='fas fa-edit'></i> Edit
                                                </button>
                                                <a href='admin.php?hapus_anggota=" . $anggota['id'] . "' class='btn btn-danger' onclick='return confirm(\"Apakah Anda yakin ingin menghapus anggota ini?\")'>
                                                    <i class='fas fa-trash'></i> Hapus
                                                </a>
                                            </td>";
                                            echo "</tr>";
                                        }
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Modal Tambah Anggota -->
                    <div id="tambahAnggotaModal" class="modal">
                        <div class="modal-content">
                            <div class="modal-header">
                                <span class="close" onclick="closeModal('tambahAnggotaModal')">&times;</span>
                                <h2>Tambah Anggota</h2>
                            </div>
                            <div class="modal-body">
                                <form method="post" action="">
                                    <div class="form-group">
                                        <label for="nama">Nama Lengkap</label>
                                        <input type="text" id="nama" name="nama" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="nomor_induk">Nomor Induk</label>
                                        <input type="text" id="nomor_induk" name="nomor_induk" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="jabatan">Jabatan</label>
                                        <select id="jabatan" name="jabatan" required>
                                            <option value="Pradana">Pradana</option>
                                            <option value="Wakil Pradana">Wakil Pradana</option>
                                            <option value="Sekretaris">Sekretaris</option>
                                            <option value="Bendahara">Bendahara</option>
                                            <option value="Anggota">Anggota</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="angkatan">Angkatan</label>
                                        <input type="number" id="angkatan" name="angkatan" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="alamat">Alamat</label>
                                        <textarea id="alamat" name="alamat" required></textarea>
                                    </div>
                                    <div class="form-group">
                                        <label for="nomor_wa">Nomor WhatsApp</label>
                                        <input type="text" id="nomor_wa" name="nomor_wa" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="tanggal_lahir">Tanggal Lahir</label>
                                        <input type="date" id="tanggal_lahir" name="tanggal_lahir" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="email">Email</label>
                                        <input type="email" id="email" name="email" required>
                                    </div>
                                    <button type="submit" name="tambah_anggota" class="btn btn-primary">Simpan</button>
                                </form>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Modal Edit Anggota -->
                    <div id="editAnggotaModal" class="modal">
                        <div class="modal-content">
                            <div class="modal-header">
                                <span class="close" onclick="closeModal('editAnggotaModal')">&times;</span>
                                <h2>Edit Anggota</h2>
                            </div>
                            <div class="modal-body">
                                <form method="post" action="">
                                    <input type="hidden" id="edit_id" name="id">
                                    <div class="form-group">
                                        <label for="edit_nama">Nama Lengkap</label>
                                        <input type="text" id="edit_nama" name="nama" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="edit_nomor_induk">Nomor Induk</label>
                                        <input type="text" id="edit_nomor_induk" name="nomor_induk" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="edit_jabatan">Jabatan</label>
                                        <select id="edit_jabatan" name="jabatan" required>
                                            <option value="Pradana">Pradana</option>
                                            <option value="Wakil Pradana">Wakil Pradana</option>
                                            <option value="Sekretaris">Sekretaris</option>
                                            <option value="Bendahara">Bendahara</option>
                                            <option value="Anggota">Anggota</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="edit_angkatan">Angkatan</label>
                                        <input type="number" id="edit_angkatan" name="angkatan" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="edit_alamat">Alamat</label>
                                        <textarea id="edit_alamat" name="alamat" required></textarea>
                                    </div>
                                    <div class="form-group">
                                        <label for="edit_nomor_wa">Nomor WhatsApp</label>
                                        <input type="text" id="edit_nomor_wa" name="nomor_wa" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="edit_tanggal_lahir">Tanggal Lahir</label>
                                        <input type="date" id="edit_tanggal_lahir" name="tanggal_lahir" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="edit_email">Email</label>
                                        <input type="email" id="edit_email" name="email" required>
                                    </div>
                                    <button type="submit" name="edit_anggota" class="btn btn-primary">Simpan Perubahan</button>
                                </form>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Modal Detail Anggota -->
                    <div id="detailAnggotaModal" class="modal">
                        <div class="modal-content">
                            <div class="modal-header">
                                <span class="close" onclick="closeModal('detailAnggotaModal')">&times;</span>
                                <h2>Detail Anggota</h2>
                            </div>
                            <div class="modal-body">
                                <div class="detail-item">
                                    <span class="detail-label">Nama:</span>
                                    <span id="detail_nama"></span>
                                </div>
                                <div class="detail-item">
                                    <span class="detail-label">Nomor Induk:</span>
                                    <span id="detail_nomor_induk"></span>
                                </div>
                                <div class="detail-item">
                                    <span class="detail-label">Jabatan:</span>
                                    <span id="detail_jabatan"></span>
                                </div>
                                <div class="detail-item">
                                    <span class="detail-label">Angkatan:</span>
                                    <span id="detail_angkatan"></span>
                                </div>
                                <div class="detail-item">
                                    <span class="detail-label">Alamat:</span>
                                    <span id="detail_alamat"></span>
                                </div>
                                <div class="detail-item">
                                    <span class="detail-label">Nomor WA:</span>
                                    <span id="detail_nomor_wa"></span>
                                </div>
                                <div class="detail-item">
                                    <span class="detail-label">Tanggal Lahir:</span>
                                    <span id="detail_tanggal_lahir"></span>
                                </div>
                                <div class="detail-item">
                                    <span class="detail-label">Email:</span>
                                    <span id="detail_email"></span>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <a id="detail_wa_button" href="#" class="btn btn-success" target="_blank">
                                    <i class="fab fa-whatsapp"></i> Hubungi via WhatsApp
                                </a>
                                <button class="btn btn-primary" onclick="closeModal('detailAnggotaModal')">Tutup</button>
                            </div>
                        </div>
                    </div>
                    
                <?php elseif ($activeTab === 'pelanggaran'): ?>
                    <!-- Kelola Pelanggaran -->
                    <div class="card">
                        <div class="card-header">
                            <div style="display: flex; justify-content: space-between; align-items: center;">
                                <span>Daftar Pelanggaran</span>
                                <button class="btn btn-primary" onclick="showTambahPelanggaranForm()">
                                    <i class="fas fa-plus"></i> Tambah Pelanggaran
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-container">
                                <table>
                                    <thead>
                                        <tr>
                                            <th>No</th>
                                            <th>Tanggal</th>
                                            <th>Nama Anggota</th>
                                            <th>Jenis Pelanggaran</th>
                                            <th>Sanksi</th>
                                            <th>Aksi</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $no = 1;
                                        foreach ($pelanggaranData['pelanggaran'] as $pelanggaran) {
                                            // Cari nama anggota berdasarkan id_anggota
                                            $namaAnggota = "";
                                            foreach ($anggotaData['anggota'] as $anggota) {
                                                if ($anggota['id'] == $pelanggaran['id_anggota']) {
                                                    $namaAnggota = $anggota['nama'];
                                                    break;
                                                }
                                            }
                                            
                                            echo "<tr>";
                                            echo "<td>" . $no++ . "</td>";
                                            echo "<td>" . $pelanggaran['tanggal'] . "</td>";
                                            echo "<td>" . $namaAnggota . "</td>";
                                            echo "<td>" . $pelanggaran['jenis_pelanggaran'] . "</td>";
                                            echo "<td>" . $pelanggaran['sanksi'] . "</td>";
                                            echo "<td class='action-buttons'>
                                                <button class='btn btn-info' onclick='showDetailPelanggaran(" . json_encode($pelanggaran) . ", \"" . $namaAnggota . "\")'>
                                                    <i class='fas fa-eye'></i> Detail
                                                </button>
                                                <button class='btn btn-primary' onclick='showEditPelanggaranForm(" . json_encode($pelanggaran) . ")'>
                                                    <i class='fas fa-edit'></i> Edit
                                                </button>
                                                <a href='admin.php?hapus_pelanggaran=" . $pelanggaran['id'] . "' class='btn btn-danger' onclick='return confirm(\"Apakah Anda yakin ingin menghapus pelanggaran ini?\")'>
                                                    <i class='fas fa-trash'></i> Hapus
                                                </a>
                                            </td>";
                                            echo "</tr>";
                                        }
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Modal Tambah Pelanggaran -->
                    <div id="tambahPelanggaranModal" class="modal">
                        <div class="modal-content">
                            <div class="modal-header">
                                <span class="close" onclick="closeModal('tambahPelanggaranModal')">&times;</span>
                                <h2>Tambah Pelanggaran</h2>
                            </div>
                            <div class="modal-body">
                                <form method="post" action="">
                                    <div class="form-group">
                                        <label for="id_anggota">Anggota</label>
                                        <select id="id_anggota" name="id_anggota" required>
                                            <?php foreach ($anggotaData['anggota'] as $anggota): ?>
                                                <option value="<?php echo $anggota['id']; ?>"><?php echo $anggota['nama']; ?> (<?php echo $anggota['nomor_induk']; ?>)</option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="tanggal">Tanggal</label>
                                        <input type="date" id="tanggal" name="tanggal" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="jenis_pelanggaran">Jenis Pelanggaran</label>
                                        <select id="jenis_pelanggaran" name="jenis_pelanggaran" required>
                                            <option value="Pelanggaran Disiplin">Pelanggaran Disiplin</option>
                                            <option value="Pelanggaran Etika">Pelanggaran Etika</option>
                                            <option value="Pelanggaran Kebersihan">Pelanggaran Kebersihan</option>
                                            <option value="Pelanggaran Hukum">Pelanggaran Hukum</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="deskripsi">Deskripsi</label>
                                        <textarea id="deskripsi" name="deskripsi" required></textarea>
                                    </div>
                                    <div class="form-group">
                                        <label for="sanksi">Sanksi</label>
                                        <select id="sanksi" name="sanksi" required>
                                            <option value="Peringatan Tertulis">Peringatan Tertulis</option>
                                            <option value="Skorsing">Skorsing</option>
                                            <option value="Pemberhentian">Pemberhentian</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="catatan">Catatan</label>
                                        <textarea id="catatan" name="catatan" required></textarea>
                                    </div>
                                    <button type="submit" name="tambah_pelanggaran" class="btn btn-primary">Simpan</button>
                                </form>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Modal Edit Pelanggaran -->
                    <div id="editPelanggaranModal" class="modal">
                        <div class="modal-content">
                            <div class="modal-header">
                                <span class="close" onclick="closeModal('editPelanggaranModal')">&times;</span>
                                <h2>Edit Pelanggaran</h2>
                            </div>
                            <div class="modal-body">
                                <form method="post" action="">
                                    <input type="hidden" id="edit_pelanggaran_id" name="id">
                                    <div class="form-group">
                                        <label for="edit_id_anggota">Anggota</label>
                                        <select id="edit_id_anggota" name="id_anggota" required>
                                            <?php foreach ($anggotaData['anggota'] as $anggota): ?>
                                                <option value="<?php echo $anggota['id']; ?>"><?php echo $anggota['nama']; ?> (<?php echo $anggota['nomor_induk']; ?>)</option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="edit_tanggal">Tanggal</label>
                                        <input type="date" id="edit_tanggal" name="tanggal" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="edit_jenis_pelanggaran">Jenis Pelanggaran</label>
                                        <select id="edit_jenis_pelanggaran" name="jenis_pelanggaran" required>
                                            <option value="Pelanggaran Disiplin">Pelanggaran Disiplin</option>
                                            <option value="Pelanggaran Etika">Pelanggaran Etika</option>
                                            <option value="Pelanggaran Kebersihan">Pelanggaran Kebersihan</option>
                                            <option value="Pelanggaran Hukum">Pelanggaran Hukum</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="edit_deskripsi">Deskripsi</label>
                                        <textarea id="edit_deskripsi" name="deskripsi" required></textarea>
                                    </div>
                                    <div class="form-group">
                                        <label for="edit_sanksi">Sanksi</label>
                                        <select id="edit_sanksi" name="sanksi" required>
                                            <option value="Peringatan Tertulis">Peringatan Tertulis</option>
                                            <option value="Skorsing">Skorsing</option>
                                            <option value="Pemberhentian">Pemberhentian</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="edit_catatan">Catatan</label>
                                        <textarea id="edit_catatan" name="catatan" required></textarea>
                                    </div>
                                    <button type="submit" name="edit_pelanggaran" class="btn btn-primary">Simpan Perubahan</button>
                                </form>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Modal Detail Pelanggaran -->
                    <div id="detailPelanggaranModal" class="modal">
                        <div class="modal-content">
                            <div class="modal-header">
                                <span class="close" onclick="closeModal('detailPelanggaranModal')">&times;</span>
                                <h2>Detail Pelanggaran</h2>
                            </div>
                            <div class="modal-body">
                                <div class="detail-item">
                                    <span class="detail-label">Nama Anggota:</span>
                                    <span id="detail_pelanggaran_nama"></span>
                                </div>
                                <div class="detail-item">
                                    <span class="detail-label">Tanggal:</span>
                                    <span id="detail_pelanggaran_tanggal"></span>
                                </div>
                                <div class="detail-item">
                                    <span class="detail-label">Jenis Pelanggaran:</span>
                                    <span id="detail_pelanggaran_jenis"></span>
                                </div>
                                <div class="detail-item">
                                    <span class="detail-label">Deskripsi:</span>
                                    <span id="detail_pelanggaran_deskripsi"></span>
                                </div>
                                <div class="detail-item">
                                    <span class="detail-label">Sanksi:</span>
                                    <span id="detail_pelanggaran_sanksi"></span>
                                </div>
                                <div class="detail-item">
                                    <span class="detail-label">Catatan:</span>
                                    <span id="detail_pelanggaran_catatan"></span>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button class="btn btn-primary" onclick="closeModal('detailPelanggaranModal')">Tutup</button>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
        </div>
    </main>

    <footer>
        <div class="container">
            <p>&copy; <?php echo date('Y'); ?> Ambalan Joko Tole Putri Koening - SMK Negeri 1 Kraksaan</p>
        </div>
    </footer>

    <script>
        // Fungsi untuk menampilkan modal
        function showModal(modalId) {
            document.getElementById(modalId).style.display = 'block';
        }
        
        // Fungsi untuk menutup modal
        function closeModal(modalId) {
            document.getElementById(modalId).style.display = 'none';
        }
        
        // Fungsi untuk menampilkan form tambah anggota
        function showTambahAnggotaForm() {
            showModal('tambahAnggotaModal');
        }
        
        // Fungsi untuk menampilkan form edit anggota
        function showEditAnggotaForm(anggota) {
            document.getElementById('edit_id').value = anggota.id;
            document.getElementById('edit_nama').value = anggota.nama;
            document.getElementById('edit_nomor_induk').value = anggota.nomor_induk;
            document.getElementById('edit_jabatan').value = anggota.jabatan;
            document.getElementById('edit_angkatan').value = anggota.angkatan;
            document.getElementById('edit_alamat').value = anggota.alamat;
            document.getElementById('edit_nomor_wa').value = anggota.nomor_wa;
            document.getElementById('edit_tanggal_lahir').value = anggota.tanggal_lahir;
            document.getElementById('edit_email').value = anggota.email;
            
            showModal('editAnggotaModal');
        }
        
        // Fungsi untuk menampilkan detail anggota
        function showDetailAnggota(anggota) {
            document.getElementById('detail_nama').textContent = anggota.nama;
            document.getElementById('detail_nomor_induk').textContent = anggota.nomor_induk;
            document.getElementById('detail_jabatan').textContent = anggota.jabatan;
            document.getElementById('detail_angkatan').textContent = anggota.angkatan;
            document.getElementById('detail_alamat').textContent = anggota.alamat;
            document.getElementById('detail_nomor_wa').textContent = anggota.nomor_wa;
            document.getElementById('detail_tanggal_lahir').textContent = anggota.tanggal_lahir;
            document.getElementById('detail_email').textContent = anggota.email;
            
            document.getElementById('detail_wa_button').href = 'https://wa.me/' + anggota.nomor_wa;
            
            showModal('detailAnggotaModal');
        }
        
        // Fungsi untuk menampilkan form tambah pelanggaran
        function showTambahPelanggaranForm() {
            // Set tanggal hari ini sebagai default
            const today = new Date().toISOString().split('T')[0];
            document.getElementById('tanggal').value = today;
            
            showModal('tambahPelanggaranModal');
        }
        
        // Fungsi untuk menampilkan form edit pelanggaran
        function showEditPelanggaranForm(pelanggaran) {
            document.getElementById('edit_pelanggaran_id').value = pelanggaran.id;
            document.getElementById('edit_id_anggota').value = pelanggaran.id_anggota;
            document.getElementById('edit_tanggal').value = pelanggaran.tanggal;
            document.getElementById('edit_jenis_pelanggaran').value = pelanggaran.jenis_pelanggaran;
            document.getElementById('edit_deskripsi').value = pelanggaran.deskripsi;
            document.getElementById('edit_sanksi').value = pelanggaran.sanksi;
            document.getElementById('edit_catatan').value = pelanggaran.catatan;
            
            showModal('editPelanggaranModal');
        }
        
        // Fungsi untuk menampilkan detail pelanggaran
        function showDetailPelanggaran(pelanggaran, namaAnggota) {
            document.getElementById('detail_pelanggaran_nama').textContent = namaAnggota;
            document.getElementById('detail_pelanggaran_tanggal').textContent = pelanggaran.tanggal;
            document.getElementById('detail_pelanggaran_jenis').textContent = pelanggaran.jenis_pelanggaran;
            document.getElementById('detail_pelanggaran_deskripsi').textContent = pelanggaran.deskripsi;
            document.getElementById('detail_pelanggaran_sanksi').textContent = pelanggaran.sanksi;
            document.getElementById('detail_pelanggaran_catatan').textContent = pelanggaran.catatan;
            
            showModal('detailPelanggaranModal');
        }
        
        // Tutup modal ketika mengklik di luar modal
        window.onclick = function(event) {
            if (event.target.classList.contains('modal')) {
                event.target.style.display = 'none';
            }
        }
    </script>
</body>
</html>
