# Aplikasi Pengelola Pelanggaran Anggota Pramuka

Aplikasi ini dibuat untuk mengelola data pelanggaran anggota aktif Ambalan Joko Tole Putri Koening (organisasi Pramuka penegak di SMK Negeri 1 Kraksaan).

## Fitur Aplikasi

1. **Manajemen Data Anggota**
   - Menyimpan data lengkap anggota (nama, nomor induk, jabatan, angkatan, alamat, nomor WA, tanggal lahir, email)
   - Menampilkan daftar anggota
   - Melihat detail anggota
   - Menghubungi anggota via WhatsApp

2. **Pencatatan Pelanggaran**
   - Mencatat pelanggaran yang dilakukan anggota
   - Menampilkan daftar pelanggaran
   - Melihat detail pelanggaran

3. **Peraturan Organisasi**
   - Menampilkan peraturan Ambalan Joko Tole Putri Koening

4. **Panel Admin**
   - Login admin/pradana
   - Mengelola data anggota (tambah, edit, hapus)
   - Mengelola data pelanggaran (tambah, edit, hapus)

## Teknologi yang Digunakan

- PHP
- JSON (untuk penyimpanan data)
- HTML/CSS/JavaScript
- Responsive design (mobile & desktop)

## Cara Penggunaan

1. **Halaman Utama (index.php)**
   - Menampilkan daftar anggota, pelanggaran, dan peraturan
   - Responsif untuk tampilan desktop dan mobile
   - Navigasi bawah untuk tampilan mobile

2. **Halaman Admin (admin.php)**
   - Login dengan username dan password
   - Mengelola data anggota dan pelanggaran
   - Responsif untuk tampilan desktop dan mobile

## Struktur Direktori

```
pramuka_app/
├── css/
│   └── style.css
├── js/
│   └── script.js
├── img/
│   └── logo.png
├── data/
│   ├── admin.json
│   ├── anggota.json
│   ├── pelanggaran.json
│   └── peraturan.json
├── api/
│   ├── get_anggota.php
│   └── get_pelanggaran_anggota.php
├── index.php
└── admin.php
```

## Akun Admin

- Username: admin
- Password: admin123

- Username: pradana
- Password: pradana123
