<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Daftar Rencana Event</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Nama Event</th>
                                <th>Penyelenggara</th>
                                <th>Tanggal Mulai</th>
                                <th>Status</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $eventPlans = loadData(EVENT_PLANS_FILE);
                            $organizers = loadData(ORGANIZERS_FILE);
                            
                            if (empty($eventPlans)) {
                                echo '<tr><td colspan="5" class="text-center">Belum ada rencana event.</td></tr>';
                            } else {
                                foreach ($eventPlans as $plan) {
                                    $organizerName = '';
                                    foreach ($organizers as $organizer) {
                                        if ($organizer['id'] === $plan['organizer_id']) {
                                            $organizerName = $organizer['name'];
                                            break;
                                        }
                                    }
                                    
                                    $statusClass = $plan['converted_to_event'] ? 'bg-success' : 'bg-warning';
                                    $statusText = $plan['converted_to_event'] ? 'Sudah jadi Event' : 'Masih Rencana';
                                    ?>
                                    <tr>
                                        <td><?= htmlspecialchars($plan['name']) ?></td>
                                        <td><?= htmlspecialchars($organizerName) ?></td>
                                        <td><?= date('d/m/Y', strtotime($plan['event_start'])) ?></td>
                                        <td><span class="badge <?= $statusClass ?>"><?= $statusText ?></span></td>
                                        <td>
                                            <button type="button" class="btn btn-sm btn-outline-info" data-bs-toggle="modal" data-bs-target="#detailModal<?= $plan['id'] ?>">
                                                Detail
                                            </button>
                                            <?php if (!$plan['converted_to_event']): ?>
                                                <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#convertModal<?= $plan['id'] ?>">
                                                    Jadikan Event
                                                </button>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    
                                    <!-- Detail Modal -->
                                    <div class="modal fade" id="detailModal<?= $plan['id'] ?>" tabindex="-1" aria-labelledby="detailModalLabel<?= $plan['id'] ?>" aria-hidden="true">
                                        <div class="modal-dialog modal-lg">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="detailModalLabel<?= $plan['id'] ?>">Detail Rencana Event: <?= htmlspecialchars($plan['name']) ?></h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <div class="row mb-3">
                                                        <div class="col-md-4"><strong>Penyelenggara:</strong></div>
                                                        <div class="col-md-8"><?= htmlspecialchars($organizerName) ?></div>
                                                    </div>
                                                    <div class="row mb-3">
                                                        <div class="col-md-4"><strong>Waktu Pendaftaran:</strong></div>
                                                        <div class="col-md-8">
                                                            <?= date('d/m/Y', strtotime($plan['registration_start'])) ?> - 
                                                            <?= date('d/m/Y', strtotime($plan['registration_end'])) ?>
                                                        </div>
                                                    </div>
                                                    <div class="row mb-3">
                                                        <div class="col-md-4"><strong>Waktu Pelaksanaan:</strong></div>
                                                        <div class="col-md-8">
                                                            <?= date('d/m/Y', strtotime($plan['event_start'])) ?> - 
                                                            <?= date('d/m/Y', strtotime($plan['event_end'])) ?>
                                                        </div>
                                                    </div>
                                                    <div class="row mb-3">
                                                        <div class="col-md-4"><strong>Akses Penghargaan:</strong></div>
                                                        <div class="col-md-8"><?= date('d/m/Y', strtotime($plan['award_access'])) ?></div>
                                                    </div>
                                                    <div class="row mb-3">
                                                        <div class="col-md-4"><strong>Tanggal Sapu Bersih:</strong></div>
                                                        <div class="col-md-8"><?= date('d/m/Y', strtotime($plan['cleanup_date'])) ?></div>
                                                    </div>
                                                    <div class="row mb-3">
                                                        <div class="col-md-4"><strong>Dibuat pada:</strong></div>
                                                        <div class="col-md-8"><?= date('d/m/Y H:i', strtotime($plan['created_at'])) ?></div>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                                                    <?php if (!$plan['converted_to_event']): ?>
                                                        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#convertModal<?= $plan['id'] ?>" data-bs-dismiss="modal">
                                                            Jadikan Event
                                                        </button>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Convert to Event Modal -->
                                    <?php if (!$plan['converted_to_event']): ?>
                                        <div class="modal fade" id="convertModal<?= $plan['id'] ?>" tabindex="-1" aria-labelledby="convertModalLabel<?= $plan['id'] ?>" aria-hidden="true">
                                            <div class="modal-dialog modal-lg">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="convertModalLabel<?= $plan['id'] ?>">Konversi ke Event: <?= htmlspecialchars($plan['name']) ?></h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <form method="post">
                                                        <input type="hidden" name="action" value="convert_to_event">
                                                        <input type="hidden" name="plan_id" value="<?= $plan['id'] ?>">
                                                        
                                                        <div class="modal-body">
                                                            <div class="mb-4">
                                                                <h6>Informasi Rencana Event</h6>
                                                                <div class="row mb-2">
                                                                    <div class="col-md-4"><strong>Nama Event:</strong></div>
                                                                    <div class="col-md-8"><?= htmlspecialchars($plan['name']) ?></div>
                                                                </div>
                                                                <div class="row mb-2">
                                                                    <div class="col-md-4"><strong>Penyelenggara:</strong></div>
                                                                    <div class="col-md-8"><?= htmlspecialchars($organizerName) ?></div>
                                                                </div>
                                                                <div class="row mb-2">
                                                                    <div class="col-md-4"><strong>Tanggal Pelaksanaan:</strong></div>
                                                                    <div class="col-md-8">
                                                                        <?= date('d/m/Y', strtotime($plan['event_start'])) ?> - 
                                                                        <?= date('d/m/Y', strtotime($plan['event_end'])) ?>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            
                                                            <hr>
                                                            
                                                            <div class="mb-3">
                                                                <label for="description<?= $plan['id'] ?>" class="form-label">Deskripsi Event</label>
                                                                <textarea class="form-control" id="description<?= $plan['id'] ?>" name="description" rows="6" required placeholder="Masukkan deskripsi lengkap tentang event ini"></textarea>
                                                            </div>
                                                            
                                                            <div class="mb-3">
                                                                <label class="form-label">Link Gambar/Poster (dapat lebih dari satu)</label>
                                                                <div id="image-links-container-<?= $plan['id'] ?>">
                                                                    <div class="mb-2 row">
                                                                        <div class="col-md-9">
                                                                            <input type="url" class="form-control" name="image_links[]" placeholder="https://example.com/image.jpg" required>
                                                                        </div>
                                                                        <div class="col-md-3">
                                                                            <button type="button" class="btn btn-sm btn-outline-secondary add-image-<?= $plan['id'] ?>">+ Tambah Gambar</button>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <small class="text-muted">Masukkan link gambar yang sudah di-host sebelumnya</small>
                                                            </div>
                                                        </div>
                                                        
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                                            <button type="submit" class="btn btn-primary">Konversi ke Event</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <script>
                                            document.addEventListener('DOMContentLoaded', function() {
                                                const addImageButton<?= $plan['id'] ?> = document.querySelector('.add-image-<?= $plan['id'] ?>');
                                                const imageLinksContainer<?= $plan['id'] ?> = document.getElementById('image-links-container-<?= $plan['id'] ?>');
                                                
                                                if (addImageButton<?= $plan['id'] ?> && imageLinksContainer<?= $plan['id'] ?>) {
                                                    addImageButton<?= $plan['id'] ?>.addEventListener('click', function() {
                                                        const imageRow = document.createElement('div');
                                                        imageRow.className = 'mb-2 row';
                                                        imageRow.innerHTML = `
                                                            <div class="col-md-9">
                                                                <input type="url" class="form-control" name="image_links[]" placeholder="https://example.com/image.jpg">
                                                            </div>
                                                            <div class="col-md-3">
                                                                <button type="button" class="btn btn-sm btn-outline-danger remove-image">Hapus</button>
                                                            </div>
                                                        `;
                                                        imageLinksContainer<?= $plan['id'] ?>.appendChild(imageRow);
                                                        
                                                        // Add event listener to the remove button
                                                        const removeButton = imageRow.querySelector('.remove-image');
                                                        removeButton.addEventListener('click', function() {
                                                            imageLinksContainer<?= $plan['id'] ?>.removeChild(imageRow);
                                                        });
                                                    });
                                                }
                                            });
                                        </script>
                                    <?php endif; ?>
                                    <?php
                                }
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Tambah Rencana Event</h5>
            </div>
            <div class="card-body">
                <form method="post">
                    <input type="hidden" name="action" value="add_event_plan">
                    <div class="mb-3">
                        <label for="name" class="form-label">Nama Event</label>
                        <input type="text" class="form-control" id="name" name="name" required>
                    </div>
                    <div class="mb-3">
                        <label for="organizer_id" class="form-label">Penyelenggara</label>
                        <select class="form-select" id="organizer_id" name="organizer_id" required>
                            <option value="">Pilih Penyelenggara</option>
                            <?php
                            $organizers = loadData(ORGANIZERS_FILE);
                            foreach ($organizers as $organizer) {
                                echo '<option value="' . $organizer['id'] . '">' . htmlspecialchars($organizer['name']) . '</option>';
                            }
                            ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="registration_start" class="form-label">Tanggal Mulai Pendaftaran</label>
                        <input type="date" class="form-control" id="registration_start" name="registration_start" required>
                    </div>
                    <div class="mb-3">
                        <label for="registration_end" class="form-label">Tanggal Akhir Pendaftaran</label>
                        <input type="date" class="form-control" id="registration_end" name="registration_end" required>
                    </div>
                    <div class="mb-3">
                        <label for="event_start" class="form-label">Tanggal Mulai Event</label>
                        <input type="date" class="form-control" id="event_start" name="event_start" required>
                    </div>
                    <div class="mb-3">
                        <label for="event_end" class="form-label">Tanggal Akhir Event</label>
                        <input type="date" class="form-control" id="event_end" name="event_end" required>
                    </div>
                    <div class="mb-3">
                        <label for="award_access" class="form-label">Tanggal Akses Penghargaan</label>
                        <input type="date" class="form-control" id="award_access" name="award_access" required>
                    </div>
                    <div class="mb-3">
                        <label for="cleanup_date" class="form-label">Tanggal Sapu Bersih</label>
                        <input type="date" class="form-control" id="cleanup_date" name="cleanup_date" required>
                    </div>
                    <button type="submit" class="btn btn-primary">Simpan</button>
                </form>
            </div>
        </div>
    </div>
</div>