<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Jadwal Posting Media Partner</h5>
                <a href="index.php?page=add_promotion" class="btn btn-sm btn-light">+ Tambah Promosi</a>
            </div>
            <div class="card-body">
                <?php
                $promotions = getCurrentPromotions();
                
                if (empty($promotions)) {
                    echo '<div class="alert alert-info">Belum ada jadwal promosi.</div>';
                } else {
                    foreach ($promotions as $promotion) {
                        $event = getEntityById(EVENTS_FILE, $promotion['event_id']);
                        $mediaPartner = getEntityById(MEDIA_PARTNERS_FILE, $promotion['media_partner_id']);
                        $organizer = getEntityById(ORGANIZERS_FILE, $event['organizer_id']);
                        
                        $postDate = strtotime($promotion['post_date']);
                        $now = time();
                        $dayDiff = floor(($postDate - $now) / (60 * 60 * 24));
                        
                        $cardClass = 'promotion-card';
                        $statusText = '';
                        
                        if ($promotion['completed']) {
                            $cardClass = 'completed';
                            $statusText = '<span class="badge bg-success">Sudah Diposting</span>';
                        } elseif ($dayDiff < 0) {
                            $cardClass = 'overdue';
                            $statusText = '<span class="badge bg-danger">Terlambat</span>';
                        } elseif ($dayDiff === 0) {
                            $cardClass = 'today';
                            $statusText = '<span class="badge bg-warning">Hari Ini</span>';
                        } else {
                            $cardClass = 'upcoming';
                            $statusText = '<span class="badge bg-primary">Dalam ' . $dayDiff . ' hari</span>';
                        }
                        ?>
                        <div class="card mb-3 <?= $cardClass ?>">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-8">
                                        <h5><?= htmlspecialchars($event['name']) ?> <?= $statusText ?></h5>
                                        <p class="mb-1"><strong>Tanggal Post:</strong> <?= date('d/m/Y', $postDate) ?></p>
                                        <p class="mb-1"><strong>Media Partner:</strong> <?= htmlspecialchars($mediaPartner['name']) ?></p>
                                        <p class="mb-1"><strong>Penyelenggara:</strong> <?= htmlspecialchars($organizer['name']) ?></p>
                                        <p class="mb-1"><strong>Biaya:</strong> Rp <?= number_format($promotion['cost'], 0, ',', '.') ?></p>
                                    </div>
                                    <div class="col-md-4 text-md-end mt-3 mt-md-0">
                                        <a href="https://instagram.com/<?= htmlspecialchars(ltrim($mediaPartner['instagram'], '@')) ?>" target="_blank" class="btn btn-sm btn-outline-secondary mb-2">
                                            <i class="bi bi-instagram"></i> Lihat Instagram
                                        </a>
                                        <a href="https://wa.me/<?= htmlspecialchars(ltrim($mediaPartner['whatsapp'], '+')) ?>" target="_blank" class="btn btn-sm btn-outline-success mb-2">
                                            <i class="bi bi-whatsapp"></i> Hubungi WhatsApp
                                        </a>
                                        <?php if (!$promotion['completed']): ?>
                                            <form method="post" class="d-inline">
                                                <input type="hidden" name="action" value="mark_completed">
                                                <input type="hidden" name="promotion_id" value="<?= $promotion['id'] ?>">
                                                <button type="submit" class="btn btn-sm btn-primary">
                                                    <i class="bi bi-check-circle"></i> Tandai Sudah
                                                </button>
                                            </form>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php
                    }
                }
                ?>
            </div>
        </div>
    </div>
</div>