<div class="card">
    <div class="card-header">
        <h5 class="mb-0">Tambah Jadwal Promosi</h5>
    </div>
    <div class="card-body">
        <form method="post">
            <input type="hidden" name="action" value="add_promotion">
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="event_id" class="form-label">Event</label>
                    <select class="form-select" id="event_id" name="event_id" required>
                        <option value="">Pilih Event</option>
                        <?php
                        $events = loadData(EVENTS_FILE);
                        $preselectedEventId = isset($_GET['event_id']) ? $_GET['event_id'] : '';
                        
                        foreach ($events as $event) {
                            $selected = ($event['id'] === $preselectedEventId) ? 'selected' : '';
                            echo '<option value="' . $event['id'] . '" ' . $selected . '>' . htmlspecialchars($event['name']) . '</option>';
                        }
                        ?>
                    </select>
                </div>
                <div class="col-md-6 mb-3">
                    <label for="media_partner_id" class="form-label">Media Partner</label>
                    <select class="form-select" id="media_partner_id" name="media_partner_id" required>
                        <option value="">Pilih Media Partner</option>
                        <?php
                        $mediaPartners = loadData(MEDIA_PARTNERS_FILE);
                        $preselectedPartnerId = isset($_GET['media_partner_id']) ? $_GET['media_partner_id'] : '';
                        
                        foreach ($mediaPartners as $partner) {
                            $selected = ($partner['id'] === $preselectedPartnerId) ? 'selected' : '';
                            echo '<option value="' . $partner['id'] . '" ' . $selected . '>' . htmlspecialchars($partner['name']) . '</option>';
                        }
                        ?>
                    </select>
                </div>
            </div>
            
            <div class="mb-3">
                <label class="form-label">Tanggal Posting</label>
                <div id="post-dates-container">
                    <div class="mb-2 row">
                        <div class="col-md-6">
                            <input type="date" class="form-control" name="post_dates[]" required>
                        </div>
                        <div class="col-md-6">
                            <button type="button" class="btn btn-sm btn-outline-secondary add-date">+ Tambah Tanggal</button>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="mb-3">
                <label for="cost" class="form-label">Biaya Promosi</label>
                <div class="input-group">
                    <span class="input-group-text">Rp</span>
                    <input type="number" class="form-control" id="cost" name="cost" required>
                </div>
            </div>
            
            <button type="submit" class="btn btn-primary">Simpan Jadwal</button>
        </form>
    </div>
</div>