<?php
session_start();

// Check if user is logged in
$isLoggedIn = isset($_SESSION['logged_in']) && $_SESSION['logged_in'] === true;

// Handle login
if (isset($_POST['login'])) {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    
    if ($username === 'rizaldi' && $password === 'admin123') {
        $_SESSION['logged_in'] = true;
        header('Location: ' . $_SERVER['PHP_SELF']);
        exit;
    } else {
        $loginError = "Username atau password salah!";
    }
}

// Handle logout
if (isset($_GET['logout'])) {
    session_destroy();
    header('Location: ' . $_SERVER['PHP_SELF']);
    exit;
}

// Function to generate random name
function generateRandomName() {
    $firstNames = ['Andi', 'Budi', 'Citra', 'Dewi', 'Eko', 'Fani', 'Gita', 'Hadi', 'Indra', 'Joko', 'Kartika', 
                  'Laras', 'Mira', 'Nanda', 'Oscar', 'Putri', 'Qori', 'Rudi', 'Sinta', 'Tono', 'Umar', 'Vina', 
                  'Wawan', 'Xena', 'Yanto', 'Zahra', 'Agus', 'Bambang', 'Dian', 'Fadli', 'Hendra', 'Irfan', 
                  'Maya', 'Novi', 'Putra', 'Rahmat', 'Surya', 'Tari', 'Yudi', 'Zulfa', 'Adinda', 'Bagas', 
                  'Chandra', 'Dinda', 'Edwin', 'Fitri', 'Galih', 'Hesti', 'Iwan', 'Juwita', 'Karina', 'Lukman', 
                  'Maudy', 'Nadia', 'Oki', 'Pandu', 'Rina', 'Satria', 'Tiara', 'Wahyu', 'Yoga', 'Anita', 
                  'Bagus', 'Cantika', 'Dodi', 'Erni', 'Ferdi', 'Gina', 'Hermawan', 'Ica', 'Johan', 'Khairul', 
                  'Lisa', 'Maman', 'Nining', 'Opik', 'Prima', 'Qiqi', 'Reza', 'Sari', 'Teddy', 'Upik', 'Vino', 
                  'Wati', 'Xandi', 'Yulia', 'Zaki', 'Amelia', 'Bima', 'Clara', 'Dimas', 'Elsa', 'Fajar', 
                  'Gading', 'Hana', 'Ilham', 'Julia', 'Kevin', 'Luna', 'Malik', 'Nina', 'Omar', 'Prilly', 
                  'Rafli', 'Shinta', 'Taufik', 'Umi', 'Valen', 'Wisnu', 'Yolanda', 'Zidan'];
    
    $lastNames = ['Wijaya', 'Susanto', 'Hartono', 'Gunawan', 'Setiawan', 'Prakoso', 'Putra', 'Santoso', 'Kusuma', 
                 'Budiman', 'Hidayat', 'Nugraha', 'Permadi', 'Utama', 'Saputra', 'Wibowo', 'Sutanto', 'Halim', 
                 'Haryanto', 'Irawan', 'Firmansyah', 'Pradana', 'Ramadhan', 'Suryanto', 'Tanuwijaya', 'Agustian', 
                 'Bakti', 'Cahyadi', 'Darma', 'Effendi', 'Fauzi', 'Ginting', 'Hakim', 'Iskandar', 'Jailani', 
                 'Kurniawan', 'Lubis', 'Marpaung', 'Nasution', 'Oktavian', 'Panjaitan', 'Rajasa', 'Siregar', 
                 'Thamrin', 'Utomo', 'Wahyudi', 'Yusuf', 'Zulkarnain', 'Ardiansyah', 'Baihaki', 'Chandra', 
                 'Damanik', 'Erlangga', 'Firdaus', 'Gumilar', 'Hasibuan', 'Ibrahim', 'Jatmiko', 'Kusnandar', 
                 'Lazuardi', 'Maulana', 'Nainggolan', 'Oktaviani', 'Purnama', 'Ramadani', 'Sihombing', 'Tanjung', 
                 'Utami', 'Waluyo', 'Yulianto', 'Zulfahmi', 'Anggara', 'Batubara', 'Cakraningrat', 'Daulay', 
                 'Effendy', 'Fadillah', 'Ginanjar', 'Hutagalung', 'Ikhsan', 'Januar', 'Kuncoro', 'Latief', 
                 'Manullang', 'Natsir', 'Prabowo', 'Rachman', 'Sembiring', 'Tumenggung', 'Utari', 'Waskito', 
                 'Yudistira', 'Zubaidi', 'Adiwinata', 'Batara', 'Chandrawinata', 'Dharmaputra', 'Erwanto', 
                 'Fadhilah', 'Gumilang', 'Hasanuddin', 'Imran', 'Jayawardana', 'Kuswanto', 'Laksono'];
    
    $firstName = $firstNames[array_rand($firstNames)];
    $lastName = $lastNames[array_rand($lastNames)];
    
    return ['first_name' => $firstName, 'last_name' => $lastName];
}

// Function to generate random email based on name
function generateRandomEmail($firstName, $lastName) {
    $firstName = strtolower($firstName);
    $lastName = strtolower($lastName);
    
    $patterns = [
        "$firstName.$lastName",
        "$firstName$lastName",
        "$lastName.$firstName",
        "$firstName" . substr($lastName, 0, 3),
        substr($firstName, 0, 1) . "$lastName",
        "$firstName" . substr($lastName, 0, 1)
    ];
    
    $pattern = $patterns[array_rand($patterns)];
    
    // Add 2-3 random numbers as required
    $numCount = rand(2, 3);
    $numbers = "";
    for ($i = 0; $i < $numCount; $i++) {
        $numbers .= rand(0, 9);
    }
    
    return $pattern . $numbers;
}

// Function to generate random password
function generateRandomPassword($length = 0) {
    if ($length <= 0) {
        $length = rand(8, 10);
    }
    
    $chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*()_+';
    $password = '';
    
    for ($i = 0; $i < $length; $i++) {
        $password .= $chars[rand(0, strlen($chars) - 1)];
    }
    
    return $password;
}

// Initialize or get settings
$settingsFile = 'settings.json';
if (!file_exists($settingsFile)) {
    $settings = ['email_domain' => '@gmail.com'];
    file_put_contents($settingsFile, json_encode($settings));
} else {
    $settings = json_decode(file_get_contents($settingsFile), true);
}

// Handle settings update
if (isset($_POST['save_settings']) && $isLoggedIn) {
    $settings['email_domain'] = $_POST['email_domain'] ?? '@gmail.com';
    file_put_contents($settingsFile, json_encode($settings));
    $settingsSaved = true;
}

// Load or initialize saved emails
$emailsFile = 'emails.json';
if (!file_exists($emailsFile)) {
    file_put_contents($emailsFile, json_encode([]));
}
$savedEmails = json_decode(file_get_contents($emailsFile), true) ?: [];

// Handle saving new email
if (isset($_POST['save_email']) && $isLoggedIn) {
    $newEmail = [
        'first_name' => $_POST['first_name'],
        'last_name' => $_POST['last_name'],
        'email' => $_POST['email'] . $settings['email_domain'],
        'password' => $_POST['password'],
        'recovery_phone' => $_POST['recovery_phone'] ?? '',
        'recovery_email' => $_POST['recovery_email'] ?? '',
        'usage' => $_POST['usage'] ?? '',
        'created_at' => date('Y-m-d H:i:s')
    ];
    
    // Add new email at the beginning of array (newest first)
    array_unshift($savedEmails, $newEmail);
    file_put_contents($emailsFile, json_encode($savedEmails));
    $emailSaved = true;
}

// Generate new random data
if (!isset($_POST['first_name']) || isset($_POST['regenerate']) || !$isLoggedIn) {
    $name = generateRandomName();
    $firstName = $name['first_name'];
    $lastName = $name['last_name'];
    $email = generateRandomEmail($firstName, $lastName);
    $password = generateRandomPassword();
} else {
    $firstName = $_POST['first_name'];
    $lastName = $_POST['last_name'];
    $email = $_POST['email'];
    $password = $_POST['password'];
}

// Handle delete email
if (isset($_GET['delete']) && $isLoggedIn) {
    $index = (int)$_GET['delete'];
    if (isset($savedEmails[$index])) {
        array_splice($savedEmails, $index, 1);
        file_put_contents($emailsFile, json_encode($savedEmails));
        $emailDeleted = true;
    }
}

// Handle edit email
$editIndex = null;
if (isset($_GET['edit']) && $isLoggedIn) {
    $editIndex = (int)$_GET['edit'];
    if (isset($savedEmails[$editIndex])) {
        $editData = $savedEmails[$editIndex];
        // Extract domain from email
        $emailParts = explode('@', $editData['email']);
        $editData['email'] = $emailParts[0];
    }
}

// Update edited email
if (isset($_POST['update_email']) && $isLoggedIn) {
    $index = (int)$_POST['edit_index'];
    if (isset($savedEmails[$index])) {
        $savedEmails[$index] = [
            'first_name' => $_POST['first_name'],
            'last_name' => $_POST['last_name'],
            'email' => $_POST['email'] . $settings['email_domain'],
            'password' => $_POST['password'],
            'recovery_phone' => $_POST['recovery_phone'] ?? '',
            'recovery_email' => $_POST['recovery_email'] ?? '',
            'usage' => $_POST['usage'] ?? '',
            'created_at' => $savedEmails[$index]['created_at']
        ];
        file_put_contents($emailsFile, json_encode($savedEmails));
        header('Location: ?page=saved&updated=1');
        exit;
    }
}

// Handle adding new email manually
if (isset($_POST['add_manual_email']) && $isLoggedIn) {
    $newEmail = [
        'first_name' => $_POST['first_name'],
        'last_name' => $_POST['last_name'],
        'email' => $_POST['email'] . $settings['email_domain'],
        'password' => $_POST['password'],
        'recovery_phone' => $_POST['recovery_phone'] ?? '',
        'recovery_email' => $_POST['recovery_email'] ?? '',
        'usage' => $_POST['usage'] ?? '',
        'created_at' => date('Y-m-d H:i:s')
    ];
    
    // Add new email at the beginning of array (newest first)
    array_unshift($savedEmails, $newEmail);
    file_put_contents($emailsFile, json_encode($savedEmails));
    header('Location: ?page=saved&added=1');
    exit;
}

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pembuat Akun Gmail Otomatis</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <style>
        :root {
            --primary-color: #4285F4;
            --secondary-color: #34A853;
            --danger-color: #EA4335;
            --warning-color: #FBBC05;
            --dark-color: #202124;
            --light-color: #f8f9fa;
            --gray-color: #dadce0;
            --box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            --border-radius: 8px;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Roboto', Arial, sans-serif;
            background-color: var(--light-color);
            color: var(--dark-color);
            line-height: 1.6;
        }
        
        .container {
            max-width: 1100px;
            margin: 0 auto;
            padding: 15px;
        }
        
        .card {
            background: white;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            margin-bottom: 20px;
            overflow: hidden;
        }
        
        .card-header {
            background: var(--primary-color);
            color: white;
            padding: 15px 20px;
            font-size: 1.2em;
            font-weight: 500;
        }
        
        .card-body {
            padding: 20px;
        }
        
        h1 {
            color: var(--primary-color);
            margin-bottom: 20px;
            text-align: center;
            font-size: 2em;
        }
        
        .form-group {
            margin-bottom: 15px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 5px;
            font-weight: 500;
        }
        
        .form-control {
            width: 100%;
            padding: 10px;
            border: 1px solid var(--gray-color);
            border-radius: 4px;
            font-size: 16px;
            transition: border-color 0.3s;
        }
        
        .form-control:focus {
            border-color: var(--primary-color);
            outline: none;
        }
        
        .btn {
            display: inline-block;
            padding: 10px 15px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
            text-align: center;
            transition: background 0.3s, transform 0.1s;
            margin-right: 5px;
            color: white;
        }
        
        .btn:hover {
            opacity: 0.9;
            transform: translateY(-1px);
        }
        
        .btn-primary {
            background-color: var(--primary-color);
        }
        
        .btn-success {
            background-color: var(--secondary-color);
        }
        
        .btn-danger {
            background-color: var(--danger-color);
        }
        
        .btn-warning {
            background-color: var(--warning-color);
            color: var(--dark-color);
        }
        
        .btn-copy {
            padding: 5px 10px;
            font-size: 14px;
            background-color: var(--dark-color);
        }
        
        .btn-block {
            display: block;
            width: 100%;
        }
        
        .alert {
            padding: 12px 15px;
            margin-bottom: 15px;
            border-radius: 4px;
            border-left: 4px solid;
        }
        
        .alert-success {
            background-color: rgba(52, 168, 83, 0.1);
            border-left-color: var(--secondary-color);
            color: var(--secondary-color);
        }
        
        .alert-danger {
            background-color: rgba(234, 67, 53, 0.1);
            border-left-color: var(--danger-color);
            color: var(--danger-color);
        }
        
        /* Table Styles */
        .table-responsive {
            overflow-x: auto;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 10px 0;
            font-size: 0.95em;
        }
        
        th, td {
            padding: 12px 15px;
            text-align: left;
            border-bottom: 1px solid var(--gray-color);
        }
        
        th {
            background-color: #f1f3f4;
            font-weight: 500;
        }
        
        tbody tr:hover {
            background-color: #f9f9f9;
        }
        
        /* Navigation */
        .navbar {
            display: flex;
            padding: 0;
            margin-bottom: 20px;
            background-color: white;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            overflow: hidden;
        }
        
        .navbar a {
            color: var(--dark-color);
            text-decoration: none;
            padding: 15px;
            transition: all 0.3s;
            text-align: center;
            flex: 1;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .navbar a:hover {
            background-color: rgba(66, 133, 244, 0.1);
        }
        
        .navbar a.active {
            background-color: var(--primary-color);
            color: white;
        }
        
        .navbar a i {
            margin-right: 8px;
        }
        
        /* Input group styles */
        .input-group {
            display: flex;
            align-items: center;
        }
        
        .input-group .form-control {
            border-radius: 4px 0 0 4px;
            border-right: none;
        }
        
        .input-group-append {
            display: flex;
        }
        
        .input-group-text {
            padding: 10px;
            background: #f1f3f4;
            border: 1px solid var(--gray-color);
            border-left: none;
            border-radius: 0 4px 4px 0;
        }
        
        .input-group-button {
            margin-left: 5px;
        }
        
        /* Login card */
        .login-card {
            max-width: 400px;
            margin: 100px auto;
            animation: fadeIn 0.5s;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(-10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        /* Responsive adjustments */
        @media (max-width: 768px) {
            .navbar {
                flex-wrap: wrap;
            }
            
            .navbar a {
                flex: 0 0 50%;
                padding: 10px;
            }
            
            th, td {
                padding: 8px 10px;
            }
            
            .btn {
                padding: 8px 12px;
                font-size: 14px;
            }
            
            .mobile-action-buttons {
                display: flex;
                flex-direction: column;
            }
            
            .mobile-action-buttons .btn {
                margin-bottom: 5px;
                margin-right: 0;
            }
            
            .card-header {
                font-size: 1.1em;
                padding: 12px 15px;
            }
        }
        
        /* Action buttons column */
        .actions-column {
            white-space: nowrap;
        }
        
        /* Tabs */
        .tabs {
            display: flex;
            margin-bottom: 20px;
            border-bottom: 1px solid var(--gray-color);
        }
        
        .tab {
            padding: 10px 15px;
            cursor: pointer;
            margin-right: 5px;
            border-bottom: 3px solid transparent;
        }
        
        .tab.active {
            border-bottom-color: var(--primary-color);
            color: var(--primary-color);
            font-weight: bold;
        }
        
        .tab-content {
            padding: 20px 0;
        }
        
        .tab-pane {
            display: none;
        }
        
        .tab-pane.active {
            display: block;
            animation: fadeIn 0.3s;
        }
        
        /* Loading spinner */
        .spinner {
            border: 4px solid rgba(0, 0, 0, 0.1);
            width: 36px;
            height: 36px;
            border-radius: 50%;
            border-left-color: var(--primary-color);
            animation: spin 1s linear infinite;
            margin: 20px auto;
            display: none;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        /* Form with two columns */
        .form-row {
            display: flex;
            flex-wrap: wrap;
            margin-left: -10px;
            margin-right: -10px;
        }
        
        .form-col {
            padding: 0 10px;
            flex: 1;
        }
        
        @media (max-width: 576px) {
            .form-col {
                flex: 0 0 100%;
                margin-bottom: 10px;
            }
        }
        
        /* Utilities */
        .mt-3 {
            margin-top: 15px;
        }
        
        .mb-3 {
            margin-bottom: 15px;
        }
        
        .text-center {
            text-align: center;
        }
        
        .text-right {
            text-align: right;
        }
        
        .d-flex {
            display: flex;
        }
        
        .justify-content-between {
            justify-content: space-between;
        }
        
        .align-items-center {
            align-items: center;
        }
        
        .w-100 {
            width: 100%;
        }
        
        .btn-floating {
            position: fixed;
            bottom: 20px;
            right: 20px;
            width: 56px;
            height: 56px;
            border-radius: 50%;
            background: var(--primary-color);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 3px 10px rgba(0, 0, 0, 0.2);
            z-index: 1000;
            font-size: 24px;
            transition: transform 0.3s, box-shadow 0.3s;
        }
        
        .btn-floating:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
        }
        
        /* Modal */
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            z-index: 1001;
            overflow-y: auto;
            padding: 50px 0;
        }
        
        .modal-content {
            background: white;
            max-width: 600px;
            margin: 0 auto;
            border-radius: var(--border-radius);
            overflow: hidden;
            animation: modalFadeIn 0.3s;
        }
        
        @keyframes modalFadeIn {
            from { opacity: 0; transform: translateY(-30px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .modal-header {
            background: var(--primary-color);
            color: white;
            padding: 15px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .modal-header h3 {
            margin: 0;
        }
        
        .modal-close {
            cursor: pointer;
            font-size: 24px;
            color: white;
        }
        
        .modal-body {
            padding: 20px;
        }
        
        .modal-footer {
            padding: 15px 20px;
            border-top: 1px solid var(--gray-color);
            text-align: right;
        }
        
        /* Tooltip */
        .tooltip {
            position: relative;
            display: inline-block;
        }
        
        .tooltip .tooltiptext {
            visibility: hidden;
            width: 120px;
            background-color: var(--dark-color);
            color: white;
            text-align: center;
            border-radius: 4px;
            padding: 5px;
            position: absolute;
            z-index: 1;
            bottom: 125%;
            left: 50%;
            margin-left: -60px;
            opacity: 0;
            transition: opacity 0.3s;
            font-size: 14px;
        }
        
        .tooltip:hover .tooltiptext {
            visibility: visible;
            opacity: 1;
        }
    </style>
</head>
<body>
    <div class="container">
        <?php if (!$isLoggedIn): ?>
            <!-- Login Form -->
            <div class="login-card card">
                <div class="card-header">
                    <i class="fas fa-lock"></i> Login
                </div>
                <div class="card-body">
                    <?php if (isset($loginError)): ?>
                        <div class="alert alert-danger">
                            <i class="fas fa-exclamation-circle"></i> <?php echo $loginError; ?>
                        </div>
                    <?php endif; ?>
                    
                    <form method="post">
                        <div class="form-group">
                            <label for="username"><i class="fas fa-user"></i> Username</label>
                            <input type="text" id="username" name="username" class="form-control" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="password"><i class="fas fa-key"></i> Password</label>
                            <input type="password" id="password" name="password" class="form-control" required>
                        </div>
                        
                        <button type="submit" name="login" class="btn btn-primary btn-block">
                            <i class="fas fa-sign-in-alt"></i> Login
                        </button>
                    </form>
                </div>
            </div>
        <?php else: ?>
            <h1><i class="fab fa-google"></i> Pembuat Akun Gmail Otomatis</h1>
            
            <!-- Navigation -->
            <div class="navbar">
                <a href="?page=generator" class="<?php echo (!isset($_GET['page']) || $_GET['page'] == 'generator') ? 'active' : ''; ?>">
                    <i class="fas fa-random"></i> Generator
                </a>
                <a href="?page=saved" class="<?php echo (isset($_GET['page']) && $_GET['page'] == 'saved') ? 'active' : ''; ?>">
                    <i class="fas fa-envelope"></i> Email Tersimpan
                </a>
                <a href="?page=settings" class="<?php echo (isset($_GET['page']) && $_GET['page'] == 'settings') ? 'active' : ''; ?>">
                    <i class="fas fa-cog"></i> Pengaturan
                </a>
                <a href="?logout=1">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </a>
            </div>
            
            <?php
            // Page handler
            $page = $_GET['page'] ?? 'generator';
            
            switch ($page) {
                case 'saved':
                    // Saved emails page
                    ?>
                    <div class="card">
                        <div class="card-header">
                            <div class="d-flex justify-content-between align-items-center">
                                <span><i class="fas fa-envelope"></i> Email Tersimpan</span>
                                <button id="showAddModal" class="btn btn-success"><i class="fas fa-plus"></i> Tambah Email</button>
                            </div>
                        </div>
                        <div class="card-body">
                            <?php if (isset($emailDeleted) || isset($_GET['deleted'])): ?>
                                <div class="alert alert-success">
                                    <i class="fas fa-check-circle"></i> Email berhasil dihapus!
                                </div>
                            <?php endif; ?>
                            
                            <?php if (isset($_GET['updated'])): ?>
                                <div class="alert alert-success">
                                    <i class="fas fa-check-circle"></i> Email berhasil diperbarui!
                                </div>
                            <?php endif; ?>
                            
                            <?php if (isset($_GET['added'])): ?>
                                <div class="alert alert-success">
                                    <i class="fas fa-check-circle"></i> Email berhasil ditambahkan!
                                </div>
                            <?php endif; ?>
                            
                            <?php if (empty($savedEmails)): ?>
                                <div class="text-center">
                                    <i class="fas fa-inbox" style="font-size: 48px; color: #ccc; margin: 20px 0;"></i>
                                    <p>Belum ada email yang tersimpan.</p>
                                </div>
                            <?php else: ?>
                                <div class="table-responsive">
                                    <table>
                                        <thead>
                                            <tr>
                                                <th>No</th>
                                                <th>Nama</th>
                                                <th>Email</th>
                                                <th>Password</th>
                                                <th>Recovery</th>
                                                <th>Penggunaan</th>
                                                <th>Tanggal Dibuat</th>
                                                <th>Aksi</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($savedEmails as $index => $email): ?>
                                            <tr>
                                                <td><?php echo $index + 1; ?></td>
                                                <td><?php echo htmlspecialchars($email['first_name'] . ' ' . $email['last_name']); ?></td>
                                                <td>
                                                    <div class="tooltip">
                                                        <?php echo htmlspecialchars($email['email']); ?>
                                                        <span class="tooltiptext">Klik untuk menyalin</span>
                                                    </div>
                                                    <button class="btn btn-copy" onclick="copyToClipboard('<?php echo htmlspecialchars($email['email']); ?>')">
                                                        <i class="fas fa-copy"></i>
                                                    </button>
                                                </td>
                                                <td>
                                                    <div class="tooltip">
                                                        <?php echo htmlspecialchars($email['password']); ?>
                                                        <span class="tooltiptext">Klik untuk menyalin</span>
                                                    </div>
                                                    <button class="btn btn-copy" onclick="copyToClipboard('<?php echo htmlspecialchars($email['password']); ?>')">
                                                        <i class="fas fa-copy"></i>
                                                    </button>
                                                </td>
                                                <td>
                                                    <?php 
                                                    $recovery = [];
                                                    if (!empty($email['recovery_phone'])) {
                                                        $recovery[] = '<i class="fas fa-phone"></i> ' . htmlspecialchars($email['recovery_phone']);
                                                    }
                                                    if (!empty($email['recovery_email'])) {
                                                        $recovery[] = '<i class="fas fa-envelope"></i> ' . htmlspecialchars($email['recovery_email']);
                                                    }
                                                    echo !empty($recovery) ? implode('<br>', $recovery) : '-';
                                                    ?>
                                                </td>
                                                <td><?php echo !empty($email['usage']) ? htmlspecialchars($email['usage']) : '-'; ?></td>
                                                <td><?php echo htmlspecialchars($email['created_at']); ?></td>
                                                <td class="actions-column">
                                                    <div class="mobile-action-buttons">
                                                        <a href="?page=saved&edit=<?php echo $index; ?>" class="btn btn-warning">
                                                            <i class="fas fa-edit"></i>
                                                        </a>
                                                        <a href="?page=saved&delete=<?php echo $index; ?>" class="btn btn-danger" onclick="return confirm('Yakin ingin menghapus?')">
                                                            <i class="fas fa-trash"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <?php if (isset($_GET['edit']) && isset($editData)): ?>
                    <!-- Edit Email Form -->
                    <div class="card">
                        <div class="card-header">
                            <i class="fas fa-edit"></i> Edit Email
                        </div>
                        <div class="card-body">
                            <form method="post">
                                <input type="hidden" name="edit_index" value="<?php echo $editIndex; ?>">
                                
                                <div class="form-row">
                                    <div class="form-col">
                                        <div class="form-group">
                                            <label for="first_name">Nama Depan</label>
                                            <input type="text" id="first_name" name="first_name" class="form-control" value="<?php echo htmlspecialchars($editData['first_name']); ?>" required>
                                        </div>
                                    </div>
                                    <div class="form-col">
                                        <div class="form-group">
                                            <label for="last_name">Nama Belakang</label>
                                            <input type="text" id="last_name" name="last_name" class="form-control" value="<?php echo htmlspecialchars($editData['last_name']); ?>" required>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <label for="email">Email</label>
                                    <div class="input-group">
                                        <input type="text" id="email" name="email" class="form-control" value="<?php echo htmlspecialchars($editData['email']); ?>" required>
                                        <div class="input-group-append">
                                            <span class="input-group-text"><?php echo htmlspecialchars($settings['email_domain']); ?></span>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <label for="password">Password</label>
                                    <input type="text" id="password" name="password" class="form-control" value="<?php echo htmlspecialchars($editData['password']); ?>" required>
                                </div>
                                
                                <div class="form-row">
                                    <div class="form-col">
                                        <div class="form-group">
                                            <label for="recovery_phone">Nomor HP Pemulihan</label>
                                            <input type="text" id="recovery_phone" name="recovery_phone" class="form-control" value="<?php echo htmlspecialchars($editData['recovery_phone'] ?? ''); ?>" placeholder="Opsional">
                                        </div>
                                    </div>
                                    <div class="form-col">
                                        <div class="form-group">
                                            <label for="recovery_email">Email Pemulihan</label>
                                            <input type="email" id="recovery_email" name="recovery_email" class="form-control" value="<?php echo htmlspecialchars($editData['recovery_email'] ?? ''); ?>" placeholder="Opsional">
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <label for="usage">Penggunaan</label>
                                    <textarea id="usage" name="usage" class="form-control" rows="3" placeholder="Deskripsikan penggunaan email ini"><?php echo htmlspecialchars($editData['usage'] ?? ''); ?></textarea>
                                </div>
                                
                                <div class="form-group text-right">
                                    <a href="?page=saved" class="btn btn-danger">Batal</a>
                                    <button type="submit" name="update_email" class="btn btn-primary">Perbarui Email</button>
                                </div>
                            </form>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <!-- Add Email Modal -->
                    <div id="addEmailModal" class="modal">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h3><i class="fas fa-plus"></i> Tambah Email Baru</h3>
                                <span class="modal-close">&times;</span>
                            </div>
                            <div class="modal-body">
                                <form method="post">
                                    <div class="form-row">
                                        <div class="form-col">
                                            <div class="form-group">
                                                <label for="first_name_manual">Nama Depan</label>
                                                <input type="text" id="first_name_manual" name="first_name" class="form-control" required>
                                            </div>
                                        </div>
                                        <div class="form-col">
                                            <div class="form-group">
                                                <label for="last_name_manual">Nama Belakang</label>
                                                <input type="text" id="last_name_manual" name="last_name" class="form-control" required>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for="email_manual">Email</label>
                                        <div class="input-group">
                                            <input type="text" id="email_manual" name="email" class="form-control" required>
                                            <div class="input-group-append">
                                                <span class="input-group-text"><?php echo htmlspecialchars($settings['email_domain']); ?></span>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for="password_manual">Password</label>
                                        <input type="text" id="password_manual" name="password" class="form-control" required>
                                    </div>
                                    
                                    <div class="form-row">
                                        <div class="form-col">
                                            <div class="form-group">
                                                <label for="recovery_phone_manual">Nomor HP Pemulihan</label>
                                                <input type="text" id="recovery_phone_manual" name="recovery_phone" class="form-control" placeholder="Opsional">
                                            </div>
                                        </div>
                                        <div class="form-col">
                                            <div class="form-group">
                                                <label for="recovery_email_manual">Email Pemulihan</label>
                                                <input type="email" id="recovery_email_manual" name="recovery_email" class="form-control" placeholder="Opsional">
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for="usage_manual">Penggunaan</label>
                                        <textarea id="usage_manual" name="usage" class="form-control" rows="3" placeholder="Deskripsikan penggunaan email ini"></textarea>
                                    </div>
                                    
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-danger modal-close-btn">Batal</button>
                                        <button type="submit" name="add_manual_email" class="btn btn-primary">Simpan Email</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <?php
                    break;
                    
                case 'settings':
                    // Settings page
                    ?>
                    <div class="card">
                        <div class="card-header">
                            <i class="fas fa-cog"></i> Pengaturan
                        </div>
                        <div class="card-body">
                            <?php if (isset($settingsSaved)): ?>
                                <div class="alert alert-success">
                                    <i class="fas fa-check-circle"></i> Pengaturan berhasil disimpan!
                                </div>
                            <?php endif; ?>
                            
                            <form method="post">
                                <div class="form-group">
                                    <label for="email_domain">Domain Email</label>
                                    <input type="text" id="email_domain" name="email_domain" class="form-control" value="<?php echo htmlspecialchars($settings['email_domain']); ?>" required>
                                </div>
                                
                                <div class="form-group text-right">
                                    <button type="submit" name="save_settings" class="btn btn-primary">
                                        <i class="fas fa-save"></i> Simpan Pengaturan
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                    <?php
                    break;
                    
                default: // generator page
                    // Email generator page
                    ?>
                    <div class="card">
                        <div class="card-header">
                            <i class="fas fa-random"></i> Generator Email
                        </div>
                        <div class="card-body">
                            <?php if (isset($emailSaved)): ?>
                                <div class="alert alert-success">
                                    <i class="fas fa-check-circle"></i> Email berhasil disimpan!
                                </div>
                            <?php endif; ?>
                            
                            <form method="post" class="generator-form">
                                <div class="form-row">
                                    <div class="form-col">
                                        <div class="form-group">
                                            <label for="first_name">Nama Depan</label>
                                            <div class="input-group">
                                                <input type="text" id="first_name" name="first_name" class="form-control" value="<?php echo htmlspecialchars($firstName); ?>" required>
                                                <div class="input-group-button">
                                                    <button type="button" class="btn btn-copy" onclick="copyToClipboard('<?php echo htmlspecialchars($firstName); ?>')">
                                                        <i class="fas fa-copy"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-col">
                                        <div class="form-group">
                                            <label for="last_name">Nama Belakang</label>
                                            <div class="input-group">
                                                <input type="text" id="last_name" name="last_name" class="form-control" value="<?php echo htmlspecialchars($lastName); ?>" required>
                                                <div class="input-group-button">
                                                    <button type="button" class="btn btn-copy" onclick="copyToClipboard('<?php echo htmlspecialchars($lastName); ?>')">
                                                        <i class="fas fa-copy"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <label for="email">Email</label>
                                    <div class="input-group">
                                        <input type="text" id="email" name="email" class="form-control" value="<?php echo htmlspecialchars($email); ?>" required>
                                        <div class="input-group-append">
                                            <span class="input-group-text"><?php echo htmlspecialchars($settings['email_domain']); ?></span>
                                        </div>
                                        <div class="input-group-button">
                                            <button type="button" class="btn btn-copy" onclick="copyToClipboard('<?php echo htmlspecialchars($email . $settings['email_domain']); ?>')">
                                                <i class="fas fa-copy"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <label for="password">Password</label>
                                    <div class="input-group">
                                        <input type="text" id="password" name="password" class="form-control" value="<?php echo htmlspecialchars($password); ?>" required>
                                        <div class="input-group-button">
                                            <button type="button" class="btn btn-copy" onclick="copyToClipboard('<?php echo htmlspecialchars($password); ?>')">
                                                <i class="fas fa-copy"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-row">
                                    <div class="form-col">
                                        <div class="form-group">
                                            <label for="recovery_phone">Nomor HP Pemulihan</label>
                                            <input type="text" id="recovery_phone" name="recovery_phone" class="form-control" placeholder="Opsional">
                                        </div>
                                    </div>
                                    <div class="form-col">
                                        <div class="form-group">
                                            <label for="recovery_email">Email Pemulihan</label>
                                            <input type="email" id="recovery_email" name="recovery_email" class="form-control" placeholder="Opsional">
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <label for="usage">Penggunaan</label>
                                    <textarea id="usage" name="usage" class="form-control" rows="3" placeholder="Deskripsikan penggunaan email ini"></textarea>
                                </div>
                                
                                <div class="form-group text-right">
                                    <button type="submit" name="regenerate" class="btn btn-warning">
                                        <i class="fas fa-dice"></i> Acak Email
                                    </button>
                                    <button type="submit" name="save_email" class="btn btn-primary">
                                        <i class="fas fa-save"></i> Simpan Email
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                    <?php
                    break;
            }
            ?>
        <?php endif; ?>
    </div>
    
    <script>
        // Function to copy text to clipboard
        function copyToClipboard(text) {
            const tempInput = document.createElement('input');
            tempInput.value = text;
            document.body.appendChild(tempInput);
            tempInput.select();
            document.execCommand('copy');
            document.body.removeChild(tempInput);
            
            // Show a small popup notification
            const notification = document.createElement('div');
            notification.textContent = 'Teks disalin!';
            notification.style.position = 'fixed';
            notification.style.bottom = '20px';
            notification.style.left = '50%';
            notification.style.transform = 'translateX(-50%)';
            notification.style.backgroundColor = 'rgba(0, 0, 0, 0.7)';
            notification.style.color = 'white';
            notification.style.padding = '10px 20px';
            notification.style.borderRadius = '4px';
            notification.style.zIndex = '9999';
            document.body.appendChild(notification);
            
            // Remove the notification after 2 seconds
            setTimeout(() => {
                document.body.removeChild(notification);
            }, 2000);
        }
        
        // Modal functionality
        document.addEventListener('DOMContentLoaded', function() {
            const modal = document.getElementById('addEmailModal');
            const showModalBtn = document.getElementById('showAddModal');
            const closeModalBtns = document.querySelectorAll('.modal-close, .modal-close-btn');
            
            if (showModalBtn) {
                showModalBtn.addEventListener('click', function() {
                    modal.style.display = 'block';
                });
            }
            
            if (closeModalBtns) {
                closeModalBtns.forEach(btn => {
                    btn.addEventListener('click', function() {
                        modal.style.display = 'none';
                    });
                });
            }
            
            // Close modal when clicking outside
            window.addEventListener('click', function(event) {
                if (event.target === modal) {
                    modal.style.display = 'none';
                }
            });
        });
    </script>
</body>
</html>