<?php
session_start();
require_once 'admin/config.php';

// Fetch blog posts from the database
$sql = "SELECT id, title, excerpt, image, category, created_at FROM posts ORDER BY created_at DESC";
$result = $conn->query($sql);

$posts = [];
if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $posts[] = $row;
    }
}
$conn->close();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cita Cerdas - Platform Olimpiade Online Nasional</title>
    <meta name="description" content="Platform kompetisi online tingkat nasional untuk mengasah kemampuan akademik anak Indonesia">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- Font Awesome for Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    
    <!-- Custom Configuration -->
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'toska': '#20b2aa',
                        'toska-dark': '#17a2b8',
                        'toska-light': '#7fdfdc',
                        'kuning': '#ffd700',
                        'kuning-light': '#ffed4e'
                    }
                }
            }
        }
    </script>
    
    <!-- CSS Styles -->
    <style>
      /* Custom Animations */
@keyframes float {
    0%, 100% { transform: translateY(0px); }
    50% { transform: translateY(-20px); }
}

.float-animation {
    animation: float 3s ease-in-out infinite;
}

/* Gradient Background */
.gradient-bg {
    background: linear-gradient(135deg, #20b2aa 0%, #17a2b8 100%);
}

/* Custom Button Styles */
.btn-primary {
    background-color: #20b2aa;
    color: white;
    font-weight: bold;
    padding: 12px 32px;
    border-radius: 9999px;
    transition: all 0.3s ease;
    transform: scale(1);
    box-shadow: 0 4px 15px rgba(32, 178, 170, 0.3);
}

.btn-primary:hover {
    background-color: #17a2b8;
    transform: scale(1.05);
    box-shadow: 0 6px 20px rgba(32, 178, 170, 0.4);
}

.btn-secondary {
    background-color: #ffd700;
    color: #374151;
    font-weight: bold;
    padding: 12px 32px;
    border-radius: 9999px;
    transition: all 0.3s ease;
    transform: scale(1);
    box-shadow: 0 4px 15px rgba(255, 215, 0, 0.3);
}

.btn-secondary:hover {
    background-color: #ffed4e;
    transform: scale(1.05);
    box-shadow: 0 6px 20px rgba(255, 215, 0, 0.4);
}

/* Card Hover Effect */
.card-hover {
    transition: all 0.3s ease;
}

.card-hover:hover {
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
    transform: translateY(-4px);
}

/* FAQ Styles */
.faq-item {
    border: 1px solid #e5e7eb;
    border-radius: 8px;
    margin-bottom: 16px;
    overflow: hidden;
}

.faq-toggle {
    width: 100%;
    padding: 16px 20px;
    text-align: left;
    font-weight: 600;
    background: none;
    border: none;
    cursor: pointer;
    display: flex;
    justify-content: space-between;
    align-items: center;
    transition: background-color 0.2s ease;
}

.faq-toggle:hover {
    background-color: #f9fafb;
}

.faq-toggle i {
    transition: transform 0.3s ease;
}

.faq-toggle.active i {
    transform: rotate(180deg);
}

.faq-content {
    padding: 16px 20px;
    background-color: #f9fafb;
    border-top: 1px solid #e5e7eb;
    display: none;
}

.faq-content.show {
    display: block;
}

/* Blog Card Styles */
.blog-card {
    background: white;
    border-radius: 12px;
    overflow: hidden;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
    transition: all 0.3s ease;
}

.blog-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
}

.blog-card img {
    width: 100%;
    height: 200px;
    object-fit: cover;
}

.blog-card-content {
    padding: 20px;
}

.blog-category {
    color: #20b2aa;
    font-size: 14px;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.blog-title {
    font-size: 18px;
    font-weight: bold;
    margin: 8px 0;
    color: #1f2937;
}

.blog-excerpt {
    color: #6b7280;
    font-size: 14px;
    line-height: 1.5;
    margin-bottom: 16px;
}

.blog-read-more {
    color: #20b2aa;
    font-weight: 600;
    text-decoration: none;
    transition: color 0.2s ease;
}

.blog-read-more:hover {
    color: #17a2b8;
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .btn-primary, .btn-secondary {
        padding: 10px 24px;
        font-size: 14px;
    }
    
    .blog-card img {
        height: 150px;
    }
    
    .blog-title {
        font-size: 16px;
    }
}

/* Smooth scrolling */
html {
    scroll-behavior: smooth;
}

/* Custom scrollbar */
::-webkit-scrollbar {
    width: 6px;
}

::-webkit-scrollbar-track {
    background: #f1f1f1;
}

::-webkit-scrollbar-thumb {
    background: #20b2aa;
    border-radius: 3px;
}

::-webkit-scrollbar-thumb:hover {
    background: #17a2b8;
}

/* Loading animation */
.loading {
    display: inline-block;
    width: 20px;
    height: 20px;
    border: 3px solid #f3f3f3;
    border-top: 3px solid #20b2aa;
    border-radius: 50%;
    animation: spin 1s linear infinite;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}
    </style>
</head>
<body class="bg-gray-50">
    <!-- Header Navigation -->
    <header class="bg-white shadow-md sticky top-0 z-50">
        <nav class="container mx-auto px-4 py-4">
            <div class="flex justify-between items-center">
                <!-- Logo -->
                <div class="flex items-center space-x-2">
                    <i class="fas fa-trophy text-toska text-3xl"></i>
                    <span class="text-2xl font-bold text-toska">Cita Cerdas</span>
                </div>
                
                <!-- Desktop Menu -->
                <div class="hidden md:flex items-center space-x-8">
                    <a href="#home" class="text-gray-700 hover:text-toska font-semibold transition-colors">Home</a>
                    <a href="#kompetisi" class="text-gray-700 hover:text-toska font-semibold transition-colors">Kompetisi</a>
                    <a href="#blog" class="text-gray-700 hover:text-toska font-semibold transition-colors">Blog</a>
                    <a href="#faq" class="text-gray-700 hover:text-toska font-semibold transition-colors">FAQ</a>
                    <a href="#kontak" class="text-gray-700 hover:text-toska font-semibold transition-colors">Kontak</a>
                    <button class="btn-primary">Daftar Sekarang</button>
                </div>
                
                <!-- Mobile Menu Button -->
                <button class="md:hidden text-gray-700" id="mobile-menu-button">
                    <i class="fas fa-bars text-2xl"></i>
                </button>
            </div>
            
            <!-- Mobile Menu -->
            <div class="hidden md:hidden mt-4" id="mobile-menu">
                <a href="#home" class="block py-2 text-gray-700 hover:text-toska font-semibold">Home</a>
                <a href="#kompetisi" class="block py-2 text-gray-700 hover:text-toska font-semibold">Kompetisi</a>
                <a href="#blog" class="block py-2 text-gray-700 hover:text-toska font-semibold">Blog</a>
                <a href="#faq" class="block py-2 text-gray-700 hover:text-toska font-semibold">FAQ</a>
                <a href="#kontak" class="block py-2 text-gray-700 hover:text-toska font-semibold">Kontak</a>
                <button class="btn-primary w-full mt-4">Daftar Sekarang</button>
            </div>
        </nav>
    </header>

    <!-- Hero Section -->
    <section id="home" class="gradient-bg text-white py-20">
        <div class="container mx-auto px-4">
            <div class="grid md:grid-cols-2 gap-8 items-center">
                <div>
                    <h1 class="text-4xl md:text-5xl font-bold mb-6">
                        Platform Olimpiade Online Nasional
                    </h1>
                    <p class="text-xl mb-8 text-gray-100">
                        Wujudkan prestasi akademik terbaik Anda bersama Cita Cerdas. Bergabunglah dengan ribuan peserta dari seluruh Indonesia!
                    </p>
                    <div class="flex flex-col sm:flex-row gap-4">
                        <button class="btn-secondary text-center">Daftar Sekarang</button>
                        <button class="bg-transparent border-2 border-white text-white font-bold py-3 px-8 rounded-full hover:bg-white hover:text-toska transition-all duration-300">
                            Pelajari Lebih Lanjut
                        </button>
                    </div>
                </div>
                <div class="relative">
                    <img src="https://pub-cdn.sider.ai/u/U0X7H89J8KV/web-coder/68cb8412788befa8028058ac/resource/43eb15f6-4c5e-40d1-be78-4014d56fa68d.jpg" alt="Anak-anak belajar" class="rounded-lg shadow-2xl float-animation">
                    <div class="absolute -bottom-4 -left-4 bg-kuning text-gray-800 p-4 rounded-lg shadow-lg">
                        <p class="font-bold">5000+</p>
                        <p class="text-sm">Peserta Aktif</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Benefits Section -->
    <section class="py-16 bg-white">
        <div class="container mx-auto px-4">
            <h2 class="text-3xl font-bold text-center mb-12 text-gray-800">
                Keuntungan Mengikuti Cita Cerdas
            </h2>
            <div class="grid md:grid-cols-3 lg:grid-cols-5 gap-6">
                <div class="text-center card-hover bg-gray-50 p-6 rounded-lg">
                    <div class="bg-toska-light w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-certificate text-toska text-2xl"></i>
                    </div>
                    <h3 class="font-semibold mb-2">Sertifikat Resmi</h3>
                    <p class="text-sm text-gray-600">Sertifikat resmi yang diakui nasional</p>
                </div>
                
                <div class="text-center card-hover bg-gray-50 p-6 rounded-lg">
                    <div class="bg-toska-light w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-medal text-toska text-2xl"></i>
                    </div>
                    <h3 class="font-semibold mb-2">Medali & Piala</h3>
                    <p class="text-sm text-gray-600">Penghargaan untuk para juara</p>
                </div>
                
                <div class="text-center card-hover bg-gray-50 p-6 rounded-lg">
                    <div class="bg-toska-light w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-globe text-toska text-2xl"></i>
                    </div>
                    <h3 class="font-semibold mb-2">Bisa dari Mana Saja</h3>
                    <p class="text-sm text-gray-600">Diikuti secara online dari rumah</p>
                </div>
                
                <div class="text-center card-hover bg-gray-50 p-6 rounded-lg">
                    <div class="bg-toska-light w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-calendar-alt text-toska text-2xl"></i>
                    </div>
                    <h3 class="font-semibold mb-2">Jadwal Fleksibel</h3>
                    <p class="text-sm text-gray-600">Pilih waktu yang sesuai untuk Anda</p>
                </div>
                
                <div class="text-center card-hover bg-gray-50 p-6 rounded-lg">
                    <div class="bg-toska-light w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-money-bill-wave text-toska text-2xl"></i>
                    </div>
                    <h3 class="font-semibold mb-2">Biaya Terjangkau</h3>
                    <p class="text-sm text-gray-600">Harga kompetisi yang bersahabat</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Blog Section -->
    <section id="blog" class="py-16 bg-gray-50">
        <div class="container mx-auto px-4">
            <h2 class="text-3xl font-bold text-center mb-12 text-gray-800">
                Artikel Terbaru
            </h2>
            <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8" id="blog-container">
                <?php if (!empty($posts)): ?>
                    <?php foreach ($posts as $post): ?>
                        <div class="blog-card">
                            <img src="<?php echo htmlspecialchars($post['image'] ?: 'https://via.placeholder.com/400x200?text=No+Image'); ?>" alt="<?php echo htmlspecialchars($post['title']); ?>" class="w-full h-48 object-cover">
                            <div class="blog-card-content">
                                <span class="blog-category"><?php echo htmlspecialchars($post['category']); ?></span>
                                <h3 class="blog-title"><?php echo htmlspecialchars($post['title']); ?></h3>
                                <p class="blog-excerpt"><?php echo htmlspecialchars($post['excerpt']); ?></p>
                                <a href="post.php?id=<?php echo $post['id']; ?>" class="blog-read-more">Baca Selengkapnya →</a>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <p class="col-span-full text-center text-gray-600">Belum ada artikel blog.</p>
                <?php endif; ?>
            </div>
            <div class="text-center mt-8">
                <a href="blog.php" class="inline-block bg-toska hover:bg-toska-dark text-white font-bold py-3 px-6 rounded-lg transition-colors">
                    Lihat Semua Artikel <i class="fas fa-arrow-right ml-2"></i>
                </a>
            </div>
        </div>
    </section>

    <!-- FAQ Section -->
    <section id="faq" class="py-16 bg-white">
        <div class="container mx-auto px-4">
            <h2 class="text-3xl font-bold text-center mb-12 text-gray-800">
                Pertanyaan Umum
            </h2>
            <div class="max-w-3xl mx-auto" id="faq-container">
                <!-- FAQ items will be loaded here from JSON -->
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="bg-gray-800 text-white py-12">
        <div class="container mx-auto px-4">
            <div class="grid md:grid-cols-4 gap-8">
                <div>
                    <div class="flex items-center space-x-2 mb-4">
                        <i class="fas fa-trophy text-kuning text-2xl"></i>
                        <span class="text-xl font-bold">Cita Cerdas</span>
                    </div>
                    <p class="text-gray-400">
                        Platform olimpiade online terpercaya untuk mengasah kemampuan akademik generasi Indonesia.
                    </p>
                </div>
                
                <div>
                    <h3 class="font-semibold mb-4">Navigasi Cepat</h3>
                    <ul class="space-y-2">
                        <li><a href="#home" class="text-gray-400 hover:text-white transition-colors">Home</a></li>
                        <li><a href="#kompetisi" class="text-gray-400 hover:text-white transition-colors">Kompetisi</a></li>
                        <li><a href="#blog" class="text-gray-400 hover:text-white transition-colors">Blog</a></li>
                        <li><a href="#faq" class="text-gray-400 hover:text-white transition-colors">FAQ</a></li>
                    </ul>
                </div>
                
                <div>
                    <h3 class="font-semibold mb-4">Kontak</h3>
                    <ul class="space-y-2 text-gray-400">
                        <li><i class="fas fa-envelope mr-2"></i>info@citacerdas.com</li>
                        <li><i class="fas fa-phone mr-2"></i>+62 812-3456-7890</li>
                        <li><i class="fas fa-map-marker-alt mr-2"></i>Jakarta, Indonesia</li>
                    </ul>
                </div>
                
                <div>
                    <h3 class="font-semibold mb-4">Media Sosial</h3>
                    <div class="flex space-x-4">
                        <a href="#" class="text-gray-400 hover:text-white transition-colors">
                            <i class="fab fa-instagram text-2xl"></i>
                        </a>
                        <a href="#" class="text-gray-400 hover:text-white transition-colors">
                            <i class="fab fa-whatsapp text-2xl"></i>
                        </a>
                        <a href="#" class="text-gray-400 hover:text-white transition-colors">
                            <i class="fab fa-youtube text-2xl"></i>
                        </a>
                    </div>
                </div>
            </div>
            
            <div class="border-t border-gray-700 mt-8 pt-8 text-center text-gray-400">
                <p>© 2025 Cita Cerdas. All rights reserved.</p>
            </div>
        </div>
    </footer>

    <!-- JavaScript -->
    <script>
      // Mobile menu toggle
document.addEventListener('DOMContentLoaded', function() {
    const mobileMenuButton = document.getElementById('mobile-menu-button');
    const mobileMenu = document.getElementById('mobile-menu');
    
    if (mobileMenuButton && mobileMenu) {
        mobileMenuButton.addEventListener('click', function() {
            mobileMenu.classList.toggle('hidden');
        });
    }
    
    // Load FAQ from JSON (Blog posts are now loaded from PHP)
    loadFAQ();
    
    // Smooth scrolling for navigation links
    setupSmoothScrolling();
    
    // Setup FAQ toggles
    setupFAQToggles();
});

// Load FAQ
function loadFAQ() {
    const faqContainer = document.getElementById('faq-container');
    if (!faqContainer) return;
    
    fetch('data/faq.json')
        .then(response => response.json())
        .then(data => {
            displayFAQ(data, faqContainer);
        })
        .catch(error => {
            console.log('FAQ will be loaded from JSON file');
            // Load placeholder FAQ
            const placeholderFAQ = [
                {
                    question: "Bagaimana cara mendaftar?",
                    answer: "Pendaftaran dapat dilakukan melalui website resmi Cita Cerdas. Isi formulir pendaftaran dengan data diri yang lengkap dan valid, lalu lakukan pembayaran biaya pendaftaran. Setelah pembayaran dikonfirmasi, Anda akan menerima email konfirmasi dan akses ke materi persiapan."
                },
                {
                    question: "Bagaimana sistem penilaian di Cita Cerdas?",
                    answer: "Penilaian dilakukan secara otomatis oleh sistem untuk soal pilihan ganda, dan oleh tim juri profesional untuk soal essay. Setiap jawaban akan dinilai berdasarkan kriteria yang telah ditetapkan. Hasil akan diumumkan dalam waktu 7 hari setelah kompetisi selesai."
                },
                {
                    question: "Apakah ada biaya pendaftaran?",
                    answer: "Ya, ada biaya pendaftaran yang bervariasi tergantung jenis kompetisi. Biaya sudah termasuk materi persiapan, akses ujian, dan sertifikat digital. Kami juga menyediakan beasiswa untuk peserta dari keluarga kurang mampu."
                },
                {
                    question: "Siapa yang bisa ikut lomba?",
                    answer: "Lomba terbuka untuk semua pelajar SD, SMP, dan SMA di seluruh Indonesia. Setiap kategori kompetisi memiliki tingkat kesulitan yang disesuaikan dengan jenjang pendidikan. Peserta harus memiliki kartu pelajar yang masih berlaku."
                },
                {
                    question: "Apa manfaat mengikuti Cita Cerdas?",
                    answer: "Selain mendapatkan sertifikat dan penghargaan, peserta akan mendapatkan pengalaman kompetisi yang berharga, meningkatkan kemampuan akademik, kesempatan untuk bersaing di tingkat nasional, dan akses ke jaringan pelajar cerdas dari seluruh Indonesia."
                },
                {
                    question: "Bagaimana cara mendapatkan informasi lebih lanjut?",
                    answer: "Anda dapat menghubungi kami melalui email info@citacerdas.com, telepon +62 812-3456-7890, atau melalui media sosial resmi Cita Cerdas. Kami juga memiliki layanan customer service yang siap membantu Senin-Jumat pukul 09.00-17.00 WIB."
                }
            ];
            displayFAQ(placeholderFAQ, faqContainer);
        });
}

// Display FAQ items
function displayFAQ(faqData, container) {
    container.innerHTML = '';
    
    faqData.forEach((item, index) => {
        const faqItem = createFAQItem(item, index);
        container.appendChild(faqItem);
    });
}

// Create FAQ item element
function createFAQItem(item, index) {
    const faqItem = document.createElement('div');
    faqItem.className = 'faq-item';
    
    faqItem.innerHTML = `
        <button class="faq-toggle" data-index="${index}">
            <span>${item.question}</span>
            <i class="fas fa-chevron-down"></i>
        </button>
        <div class="faq-content">
            <p>${item.answer}</p>
        </div>
    `;
    
    return faqItem;
}

// Setup smooth scrolling
function setupSmoothScrolling() {
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            const target = document.querySelector(this.getAttribute('href'));
            if (target) {
                target.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }
        });
    });
}

// Setup FAQ toggles
function setupFAQToggles() {
    document.addEventListener('click', function(e) {
        if (e.target.classList.contains('faq-toggle') || e.target.parentElement.classList.contains('faq-toggle')) {
            const toggle = e.target.classList.contains('faq-toggle') ? e.target : e.target.parentElement;
            const content = toggle.nextElementSibling;
            const icon = toggle.querySelector('i');
            
            // Toggle active class
            toggle.classList.toggle('active');
            content.classList.toggle('show');
            
            // Close other FAQ items
            document.querySelectorAll('.faq-toggle').forEach(otherToggle => {
                if (otherToggle !== toggle) {
                    otherToggle.classList.remove('active');
                    otherToggle.nextElementSibling.classList.remove('show');
                }
            });
        }
    });
}

// Utility functions
function showLoading(element) {
    element.innerHTML = '<div class="loading"></div>';
}

function hideLoading(element, content) {
    element.innerHTML = content;
}

function showAlert(message, type = 'info') {
    const alertDiv = document.createElement('div');
    alertDiv.className = `fixed top-4 right-4 p-4 rounded-lg shadow-lg z-50 ${
        type === 'success' ? 'bg-green-500 text-white' : 
        type === 'error' ? 'bg-red-500 text-white' : 
        'bg-blue-500 text-white'
    }`;
    alertDiv.textContent = message;
    
    document.body.appendChild(alertDiv);
    
    setTimeout(() => {
        alertDiv.remove();
    }, 3000);
}
    </script>
</body>
</html>