<?php
session_start();

// Configuration
$dataFile = 'data.json';
$isAdmin = isset($_GET['admin']) && $_GET['admin'] == 'true';
$isLoggedIn = isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true;

// Function to get redirect data
function getRedirectData() {
    global $dataFile;
    
    if (!file_exists($dataFile)) {
        return [
            'redirects' => [],
            'settings' => [
                'site_title' => 'Link Scheduler',
                'default_message' => 'Belum tersedia link saat ini.',
                'admin_password' => 'admin123'
            ]
        ];
    }
    
    $jsonData = file_get_contents($dataFile);
    return json_decode($jsonData, true);
}

// Function to save redirect data
function saveRedirectData($data) {
    global $dataFile;
    file_put_contents($dataFile, json_encode($data, JSON_PRETTY_PRINT));
}

// Get data
$data = getRedirectData();
$settings = $data['settings'];
$redirects = $data['redirects'];

// Handle admin login
if ($isAdmin && isset($_POST['action']) && $_POST['action'] === 'login') {
    if (isset($_POST['password']) && $_POST['password'] === $settings['admin_password']) {
        $_SESSION['admin_logged_in'] = true;
        header("Location: index.php?admin=true");
        exit;
    } else {
        $loginError = "Password salah!";
    }
}

// Handle admin logout
if ($isAdmin && isset($_GET['logout'])) {
    unset($_SESSION['admin_logged_in']);
    header("Location: index.php?admin=true");
    exit;
}

// Handle adding new redirect
if ($isAdmin && $isLoggedIn && isset($_POST['action']) && $_POST['action'] === 'add_redirect') {
    $newRedirect = [
        'id' => time(), // Use timestamp as ID
        'title' => $_POST['title'],
        'start_date' => $_POST['start_date'],
        'end_date' => $_POST['end_date'],
        'target_url' => $_POST['target_url'],
        'created_at' => date('Y-m-d H:i:s')
    ];
    
    $redirects[] = $newRedirect;
    $data['redirects'] = $redirects;
    saveRedirectData($data);
    
    header("Location: index.php?admin=true");
    exit;
}

// Handle deleting redirect
if ($isAdmin && $isLoggedIn && isset($_GET['delete'])) {
    $idToDelete = $_GET['delete'];
    
    foreach ($redirects as $key => $redirect) {
        if ($redirect['id'] == $idToDelete) {
            unset($redirects[$key]);
            break;
        }
    }
    
    $data['redirects'] = array_values($redirects); // Re-index array
    saveRedirectData($data);
    
    header("Location: index.php?admin=true");
    exit;
}

// Handle editing settings
if ($isAdmin && $isLoggedIn && isset($_POST['action']) && $_POST['action'] === 'update_settings') {
    $settings['site_title'] = $_POST['site_title'];
    $settings['default_message'] = $_POST['default_message'];
    
    if (!empty($_POST['new_password'])) {
        $settings['admin_password'] = $_POST['new_password'];
    }
    
    $data['settings'] = $settings;
    saveRedirectData($data);
    
    header("Location: index.php?admin=true");
    exit;
}

// If not in admin mode, check for active redirects
if (!$isAdmin) {
    $currentDateTime = date('Y-m-d H:i:s');
    $activeRedirect = null;
    
    foreach ($redirects as $redirect) {
        if ($currentDateTime >= $redirect['start_date'] && $currentDateTime <= $redirect['end_date']) {
            $activeRedirect = $redirect;
            break;
        }
    }
    
    // If there's an active redirect, redirect the user
    if ($activeRedirect) {
        header("Location: " . $activeRedirect['target_url']);
        exit;
    }
}

// CSS styles
$styles = <<<CSS
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
    font-family: 'Arial', sans-serif;
}

body {
    background-color: #f5f7fa;
    color: #333;
    line-height: 1.6;
}

.container {
    width: 100%;
    max-width: 1200px;
    margin: 0 auto;
    padding: 20px;
}

header {
    background-color: #2c3e50;
    color: white;
    padding: 15px 0;
    margin-bottom: 30px;
}

h1, h2, h3 {
    margin-bottom: 15px;
}

.card {
    background: white;
    border-radius: 8px;
    padding: 20px;
    margin-bottom: 20px;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
}

.message {
    text-align: center;
    font-size: 1.2em;
    padding: 40px;
}

.btn {
    display: inline-block;
    padding: 8px 16px;
    background: #3498db;
    color: white;
    border: none;
    border-radius: 4px;
    cursor: pointer;
    text-decoration: none;
    font-size: 14px;
    margin-right: 5px;
}

.btn:hover {
    background: #2980b9;
}

.btn-danger {
    background: #e74c3c;
}

.btn-danger:hover {
    background: #c0392b;
}

.form-group {
    margin-bottom: 15px;
}

label {
    display: block;
    margin-bottom: 5px;
    font-weight: bold;
}

input[type="text"],
input[type="password"],
input[type="datetime-local"],
textarea {
    width: 100%;
    padding: 8px;
    border: 1px solid #ddd;
    border-radius: 4px;
}

table {
    width: 100%;
    border-collapse: collapse;
    margin-bottom: 20px;
}

table th,
table td {
    padding: 10px;
    border: 1px solid #ddd;
    text-align: left;
}

table th {
    background-color: #f2f2f2;
}

.alert {
    padding: 10px;
    border-radius: 4px;
    margin-bottom: 15px;
}

.alert-danger {
    background-color: #f8d7da;
    color: #721c24;
    border: 1px solid #f5c6cb;
}

footer {
    margin-top: 30px;
    text-align: center;
    color: #777;
    font-size: 0.9em;
}

/* Responsive Styles */
@media (max-width: 768px) {
    .container {
        padding: 10px;
    }
    
    .card {
        padding: 15px;
    }
    
    table {
        display: block;
        overflow-x: auto;
    }
    
    input[type="datetime-local"] {
        font-size: 14px;
    }
}
CSS;
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $settings['site_title']; ?></title>
    <style><?php echo $styles; ?></style>
</head>
<body>
    <header>
        <div class="container">
            <h1><?php echo $settings['site_title']; ?></h1>
            <?php if ($isAdmin): ?>
                <div>
                    <?php if ($isLoggedIn): ?>
                        <a href="index.php?admin=true&logout=true" class="btn">Logout</a>
                        <a href="index.php" target="_blank" class="btn">Lihat Halaman Utama</a>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    </header>

    <div class="container">
        <?php if ($isAdmin): ?>
            <!-- Admin Panel -->
            <?php if (!$isLoggedIn): ?>
                <div class="card">
                    <h2>Login Admin</h2>
                    <?php if (isset($loginError)): ?>
                        <div class="alert alert-danger"><?php echo $loginError; ?></div>
                    <?php endif; ?>
                    <form method="post">
                        <input type="hidden" name="action" value="login">
                        <div class="form-group">
                            <label for="password">Password:</label>
                            <input type="password" id="password" name="password" required>
                        </div>
                        <button type="submit" class="btn">Login</button>
                    </form>
                </div>
            <?php else: ?>
                <div class="card">
                    <h2>Tambah Link Baru</h2>
                    <form method="post">
                        <input type="hidden" name="action" value="add_redirect">
                        <div class="form-group">
                            <label for="title">Judul:</label>
                            <input type="text" id="title" name="title" required>
                        </div>
                        <div class="form-group">
                            <label for="start_date">Waktu Mulai:</label>
                            <input type="datetime-local" id="start_date" name="start_date" required>
                        </div>
                        <div class="form-group">
                            <label for="end_date">Waktu Selesai:</label>
                            <input type="datetime-local" id="end_date" name="end_date" required>
                        </div>
                        <div class="form-group">
                            <label for="target_url">URL Tujuan:</label>
                            <input type="text" id="target_url" name="target_url" required>
                        </div>
                        <button type="submit" class="btn">Simpan</button>
                    </form>
                </div>

                <div class="card">
                    <h2>Daftar Link</h2>
                    <?php if (empty($redirects)): ?>
                        <p>Belum ada link yang ditambahkan.</p>
                    <?php else: ?>
                        <table>
                            <thead>
                                <tr>
                                    <th>Judul</th>
                                    <th>Waktu Mulai</th>
                                    <th>Waktu Selesai</th>
                                    <th>URL Tujuan</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($redirects as $redirect): ?>
                                    <tr>
                                        <td><?php echo htmlspecialchars($redirect['title']); ?></td>
                                        <td><?php echo $redirect['start_date']; ?></td>
                                        <td><?php echo $redirect['end_date']; ?></td>
                                        <td><?php echo htmlspecialchars($redirect['target_url']); ?></td>
                                        <td>
                                            <a href="index.php?admin=true&delete=<?php echo $redirect['id']; ?>" 
                                               class="btn btn-danger" 
                                               onclick="return confirm('Yakin ingin menghapus?')">Hapus</a>
                                            <a href="<?php echo $redirect['target_url']; ?>" 
                                               target="_blank" 
                                               class="btn">Lihat</a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    <?php endif; ?>
                </div>

                <div class="card">
                    <h2>Pengaturan</h2>
                    <form method="post">
                        <input type="hidden" name="action" value="update_settings">
                        <div class="form-group">
                            <label for="site_title">Judul Situs:</label>
                            <input type="text" id="site_title" name="site_title" 
                                   value="<?php echo htmlspecialchars($settings['site_title']); ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="default_message">Pesan Default:</label>
                            <textarea id="default_message" name="default_message" rows="3" required><?php echo htmlspecialchars($settings['default_message']); ?></textarea>
                        </div>
                        <div class="form-group">
                            <label for="new_password">Password Baru (kosongkan jika tidak ingin mengubah):</label>
                            <input type="password" id="new_password" name="new_password">
                        </div>
                        <button type="submit" class="btn">Simpan Pengaturan</button>
                    </form>
                </div>

                <div class="card">
                    <h2>Link URL Publik</h2>
                    <p>Bagikan link ini untuk akses pengguna:</p>
                    <div class="form-group">
                        <input type="text" value="<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]"; ?>" 
                               readonly onclick="this.select();">
                    </div>
                </div>
            <?php endif; ?>
        <?php else: ?>
            <!-- Public View (Default Landing Page) -->
            <div class="card">
                <div class="message">
                    <?php echo nl2br(htmlspecialchars($settings['default_message'])); ?>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <footer class="container">
        <p>&copy; <?php echo date('Y'); ?> <?php echo htmlspecialchars($settings['site_title']); ?> - Link Scheduler</p>
    </footer>
</body>
</html>