<?php
// Database configuration
$host = 'dezki.biz.id';
$user = 'abnomrnz_ledgr'; 
$password = '5u614N70'; 
$database = 'abnomrnz_ledgr';

// Connect to database
$conn = new mysqli($host, $user, $password, $database);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Set default timezone
date_default_timezone_set('Asia/Jakarta');

// Application settings
$app_name = "Ledger App";
$default_pin = "051205";
$theme_color = "#ba323e"; // Red theme color
$secondary_color = "#ffffff"; // White secondary color

// Function to sanitize input
function sanitize($data) {
    global $conn;
    return mysqli_real_escape_string($conn, trim($data));
}

// Function to format currency
function formatCurrency($amount) {
    return 'Rp ' . number_format($amount, 0, ',', '.');
}

// Function to log actions
function logActivity($action, $details = '') {
    global $conn;
    $ip = $_SERVER['REMOTE_ADDR'];
    $timestamp = date('Y-m-d H:i:s');
    
    $sql = "INSERT INTO audit_log (action, details, ip_address, timestamp) 
            VALUES ('".sanitize($action)."', '".sanitize($details)."', '".sanitize($ip)."', '$timestamp')";
    
    $conn->query($sql);
}

// Function to check if user is authenticated
function isAuthenticated() {
    return isset($_SESSION['authenticated']) && $_SESSION['authenticated'] === true;
}

// Function to authenticate user
function authenticate($pin) {
    global $conn;
    
    $hashedPin = sha1($pin);
    
    $sql = "SELECT * FROM auth WHERE pin = '$hashedPin'";
    $result = $conn->query($sql);
    
    if ($result->num_rows > 0) {
        $_SESSION['authenticated'] = true;
        logActivity('Login', 'Successful login');
        return true;
    }
    
    logActivity('Login', 'Failed login attempt');
    return false;
}

// Function to change PIN
function changePin($oldPin, $newPin) {
    global $conn;
    
    $hashedOldPin = sha1($oldPin);
    $hashedNewPin = sha1($newPin);
    
    // Check if old PIN is correct
    $sql = "SELECT * FROM auth WHERE pin = '$hashedOldPin'";
    $result = $conn->query($sql);
    
    if ($result->num_rows > 0) {
        // Update PIN
        $sql = "UPDATE auth SET pin = '$hashedNewPin', last_changed = NOW()";
        
        if ($conn->query($sql) === TRUE) {
            logActivity('Security', 'PIN changed');
            return true;
        }
    }
    
    return false;
}

// Function to get all entities
function getEntities() {
    global $conn;
    
    $sql = "SELECT * FROM entities WHERE is_active = 1 ORDER BY name";
    $result = $conn->query($sql);
    
    $entities = array();
    
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $entities[] = $row;
        }
    }
    
    return $entities;
}

// Function to get a single entity
function getEntity($id) {
    global $conn;
    
    $sql = "SELECT * FROM entities WHERE id = " . (int)$id;
    $result = $conn->query($sql);
    
    if ($result->num_rows > 0) {
        return $result->fetch_assoc();
    }
    
    return null;
}

// Function to add a new entity
function addEntity($name, $description) {
    global $conn;
    
    $name = sanitize($name);
    $description = sanitize($description);
    
    $sql = "INSERT INTO entities (name, description) VALUES ('$name', '$description')";
    
    if ($conn->query($sql) === TRUE) {
        logActivity('Entity', "Created entity: $name");
        return $conn->insert_id;
    }
    
    return false;
}

// Function to update an entity
function updateEntity($id, $name, $description) {
    global $conn;
    
    $id = (int)$id;
    $name = sanitize($name);
    $description = sanitize($description);
    
    $sql = "UPDATE entities SET name = '$name', description = '$description' WHERE id = $id";
    
    if ($conn->query($sql) === TRUE) {
        logActivity('Entity', "Updated entity #$id: $name");
        return true;
    }
    
    return false;
}

// Function to delete an entity (soft delete)
function deleteEntity($id) {
    global $conn;
    
    $id = (int)$id;
    
    // Check if entity has active transactions
    $sql = "SELECT COUNT(*) as count FROM transactions 
            WHERE (from_entity_id = $id OR to_entity_id = $id) 
            AND status = 'active'";
    
    $result = $conn->query($sql);
    $row = $result->fetch_assoc();
    
    if ($row['count'] > 0) {
        return 'Cannot delete entity with active transactions';
    }
    
    // Soft delete the entity
    $sql = "UPDATE entities SET is_active = 0 WHERE id = $id";
    
    if ($conn->query($sql) === TRUE) {
        logActivity('Entity', "Deleted entity #$id");
        return true;
    }
    
    return false;
}

// Function to get audit logs
function getAuditLogs($limit = 50) {
    global $conn;
    
    $sql = "SELECT * FROM audit_log ORDER BY timestamp DESC LIMIT " . (int)$limit;
    $result = $conn->query($sql);
    
    $logs = array();
    
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $logs[] = $row;
        }
    }
    
    return $logs;
}

// Function to check if tables exist, if not create them
function checkTables() {
    global $conn;
    
    // Check if entities table exists
    $result = $conn->query("SHOW TABLES LIKE 'entities'");
    
    if ($result->num_rows == 0) {
        // Tables don't exist, create them
        $sql = file_get_contents('database.sql');
        
        // Execute multi query
        if ($conn->multi_query($sql)) {
            do {
                // Store first result set
                if ($result = $conn->store_result()) {
                    $result->free();
                }
                // Print divider
                if ($conn->more_results()) {
                    // More results? -ok
                }
            } while ($conn->next_result());
        }
        
        logActivity('System', 'Database tables created');
    }
}

// Start session if not already started
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}